/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms.api;

import dragomordor.simpletms.SimpleTMsItems;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\u0007J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0019\u0010\u0018J\r\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u0003R\u001e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001d\u00a8\u0006\u001f"}, d2={"Ldragomordor/simpletms/api/MoveCaseHelper;", "", "<init>", "()V", "", "", "getSortedTMMoveNames", "()Ljava/util/List;", "getSortedTRMoveNames", "", "isTR", "getSortedMoveNames", "(Z)Ljava/util/List;", "moveName", "", "getSlotIndexForMove", "(Ljava/lang/String;Z)I", "slotIndex", "getMoveNameForSlot", "(IZ)Ljava/lang/String;", "getTMSlotCount", "()I", "getTRSlotCount", "getSlotCount", "(Z)I", "getRowCount", "", "invalidateCache", "sortedTMMoveNames", "Ljava/util/List;", "sortedTRMoveNames", "common"})
public final class MoveCaseHelper {
    @NotNull
    public static final MoveCaseHelper INSTANCE = new MoveCaseHelper();
    @Nullable
    private static List<String> sortedTMMoveNames;
    @Nullable
    private static List<String> sortedTRMoveNames;

    private MoveCaseHelper() {
    }

    @NotNull
    public final List<String> getSortedTMMoveNames() {
        if (sortedTMMoveNames == null) {
            sortedTMMoveNames = CollectionsKt.sorted((Iterable)SimpleTMsItems.INSTANCE.getALL_MOVE_NAMES_WITH_TM_ITEMS());
        }
        List<String> list = sortedTMMoveNames;
        Intrinsics.checkNotNull(list);
        return list;
    }

    @NotNull
    public final List<String> getSortedTRMoveNames() {
        if (sortedTRMoveNames == null) {
            sortedTRMoveNames = CollectionsKt.sorted((Iterable)SimpleTMsItems.INSTANCE.getALL_MOVE_NAMES_WITH_TR_ITEMS());
        }
        List<String> list = sortedTRMoveNames;
        Intrinsics.checkNotNull(list);
        return list;
    }

    @NotNull
    public final List<String> getSortedMoveNames(boolean isTR) {
        return isTR ? this.getSortedTRMoveNames() : this.getSortedTMMoveNames();
    }

    public final int getSlotIndexForMove(@NotNull String moveName, boolean isTR) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        return this.getSortedMoveNames(isTR).indexOf(moveName);
    }

    @Nullable
    public final String getMoveNameForSlot(int slotIndex, boolean isTR) {
        List<String> moves = this.getSortedMoveNames(isTR);
        return (0 <= slotIndex ? slotIndex < ((Collection)moves).size() : false) ? moves.get(slotIndex) : null;
    }

    public final int getTMSlotCount() {
        return this.getSortedTMMoveNames().size();
    }

    public final int getTRSlotCount() {
        return this.getSortedTRMoveNames().size();
    }

    public final int getSlotCount(boolean isTR) {
        return isTR ? this.getTRSlotCount() : this.getTMSlotCount();
    }

    public final int getRowCount(boolean isTR) {
        int slotCount = this.getSlotCount(isTR);
        return (slotCount + 8) / 9;
    }

    public final void invalidateCache() {
        sortedTMMoveNames = null;
        sortedTRMoveNames = null;
    }
}

