/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.property;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.gear.trait.Trait;

public class TraitListPropertyValue
extends GearPropertyValue<List<TraitInstance>> {
    public TraitListPropertyValue(List<TraitInstance> value) {
        super(ImmutableList.copyOf(value));
    }

    public static TraitListPropertyValue empty() {
        return new TraitListPropertyValue(Collections.emptyList());
    }

    public static TraitListPropertyValue single(DataResource<Trait> trait, int level) {
        return new TraitListPropertyValue(Collections.singletonList(TraitInstance.of(trait, level, new ITraitCondition[0])));
    }

    public static TraitListPropertyValue of(TraitInstance ... traits) {
        return new TraitListPropertyValue(Arrays.stream(traits).toList());
    }

    public static TraitListPropertyValue from(Collection<TraitInstance> traits) {
        return new TraitListPropertyValue(List.copyOf(traits));
    }

    public String toString() {
        String listText = ((List)this.value).stream().map(trait -> trait.getDisplayName().toString()).collect(Collectors.joining(", "));
        return "[" + listText + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TraitListPropertyValue)) {
            return false;
        }
        TraitListPropertyValue other = (TraitListPropertyValue)obj;
        return ((List)this.value).equals(other.value);
    }

    @Override
    public int hashCode() {
        return ((List)this.value).hashCode();
    }
}

