/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.block;

import dev.compactmods.machines.LoggingUtil;
import dev.compactmods.machines.api.CompactMachines;
import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.component.CMDataComponents;
import dev.compactmods.machines.api.dimension.MissingDimensionException;
import dev.compactmods.machines.api.machine.MachineColor;
import dev.compactmods.machines.api.room.RoomInstance;
import dev.compactmods.machines.api.room.history.RoomEntryPoint;
import dev.compactmods.machines.api.room.template.RoomTemplate;
import dev.compactmods.machines.api.room.template.RoomTemplateHelper;
import dev.compactmods.machines.api.shrinking.PSDTags;
import dev.compactmods.machines.machine.Machines;
import dev.compactmods.machines.machine.block.BoundCompactMachineBlock;
import dev.compactmods.machines.machine.block.CompactMachineBlock;
import dev.compactmods.machines.machine.block.UnboundCompactMachineEntity;
import dev.compactmods.machines.room.RoomHelper;
import dev.compactmods.machines.shrinking.PersonalShrinkingDevice;
import dev.compactmods.machines.shrinking.Shrinking;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnboundCompactMachineBlock
extends CompactMachineBlock
implements EntityBlock {
    public UnboundCompactMachineBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        UnboundCompactMachineEntity be;
        ResourceLocation id;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof UnboundCompactMachineEntity && (id = (be = (UnboundCompactMachineEntity)blockEntity).templateId()) != null) {
            Holder.Reference template = RoomTemplateHelper.getTemplateHolder((LevelReader)level, (ResourceLocation)id);
            ItemStack item = Machines.Items.forNewRoom((Holder.Reference<RoomTemplate>)template);
            be.getExistingData(CMDataAttachments.MACHINE_COLOR).ifPresent(color -> item.set((Supplier)CMDataComponents.MACHINE_COLOR, color));
            Component cn = be.customName();
            if (cn != null) {
                item.set(DataComponents.CUSTOM_NAME, (Object)cn);
            }
            return item;
        }
        return Machines.Items.unbound();
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new UnboundCompactMachineEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand p_316595_, BlockHitResult p_316140_) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            if (!level.isClientSide && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return UnboundCompactMachineBlock.tryDyingMachine(serverLevel, pos, player, dye, stack);
            }
        }
        MinecraftServer server = level.getServer();
        if ((stack.is(PSDTags.ITEM) || stack.has(Shrinking.DataComponents.SHRINKING_CONFIG)) && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            level.getBlockEntity(pos, (BlockEntityType)Machines.BlockEntities.UNBOUND_MACHINE.get()).ifPresent(unboundEntity -> {
                RoomTemplate template = RoomTemplateHelper.getTemplate((LevelReader)level, (ResourceLocation)unboundEntity.templateId());
                if (!template.equals((Object)RoomTemplate.INVALID_TEMPLATE)) {
                    MachineColor color = (MachineColor)unboundEntity.getData(CMDataAttachments.MACHINE_COLOR);
                    try {
                        RoomInstance newRoom = CompactMachines.newRoom((MinecraftServer)server, (RoomTemplate)template, (UUID)sp.getUUID());
                        newRoom.setData(CMDataAttachments.ROOM_OWNER, (Object)player.getUUID());
                        level.setBlock(pos, ((BoundCompactMachineBlock)((Object)((Object)Machines.Blocks.BOUND_MACHINE.get()))).defaultBlockState(), 3);
                        level.getBlockEntity(pos, (BlockEntityType)Machines.BlockEntities.MACHINE.get()).ifPresent(ent -> {
                            ent.setConnectedRoom(newRoom.code());
                            ent.setOwner(sp.getUUID());
                            ent.setData(CMDataAttachments.MACHINE_COLOR, color);
                            try {
                                RoomHelper.teleportPlayerIntoRoom(server, sp, newRoom, RoomEntryPoint.playerEnteringMachine((Player)player)).thenAccept(res -> PersonalShrinkingDevice.handleSuccessfulAtomicShift(stack, sp, PersonalShrinkingDevice.config(stack)));
                            }
                            catch (MissingDimensionException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    catch (MissingDimensionException e) {
                        LoggingUtil.modLog().error("Error occurred while generating new room and machine info for first player entry.", (Throwable)e);
                    }
                } else {
                    LoggingUtil.modLog().fatal("Tried to create and enter an invalidly-registered room. Something went very wrong!");
                }
            });
        }
        return super.useItemOn(stack, state, level, pos, player, p_316595_, p_316140_);
    }
}

