/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.client.machine;

import dev.compactmods.gander.level.VirtualLevel;
import dev.compactmods.gander.render.geometry.BakedLevel;
import dev.compactmods.gander.render.geometry.LevelBakery;
import dev.compactmods.machines.api.attachment.CMDataAttachments;
import dev.compactmods.machines.api.machine.MachineColor;
import dev.compactmods.machines.api.machine.MachineConstants;
import dev.compactmods.machines.client.config.ClientConfig;
import dev.compactmods.machines.client.room.MachineRoomScreen;
import dev.compactmods.machines.network.machine.OpenMachinePreviewScreenPacket;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class ClientMachinePacketHandler {
    public static void setMachineColor(GlobalPos position, MachineColor newColor) {
        Minecraft mc = Minecraft.getInstance();
        assert (mc.level != null);
        if (mc.level.dimension() == position.dimension()) {
            BlockState state = mc.level.getBlockState(position.pos());
            BlockEntity blockEntity = mc.level.getBlockEntity(position.pos());
            if (state.is(MachineConstants.MACHINE_BLOCK)) {
                blockEntity.setData(CMDataAttachments.MACHINE_COLOR, (Object)newColor);
                mc.level.sendBlockUpdated(position.pos(), state, state, 11);
            }
        }
    }

    public static void openRoomPreviewScreen(OpenMachinePreviewScreenPacket pkt) {
        Minecraft mc = Minecraft.getInstance();
        mc.setScreen((Screen)new MachineRoomScreen((Component)Component.empty(), pkt.machinePos(), pkt.roomCode()));
        Screen screen = mc.screen;
        if (screen instanceof MachineRoomScreen) {
            MachineRoomScreen mrs = (MachineRoomScreen)screen;
            if (((Boolean)ClientConfig.ENABLE_ROOM_PREVIEWS.get()).booleanValue()) {
                CompletableFuture<BakedLevel> setup = CompletableFuture.supplyAsync(() -> {
                    VirtualLevel virtualLevel = new VirtualLevel(Minecraft.getInstance().level.registryAccess(), true);
                    AABB bounds = AABB.of((BoundingBox)pkt.internalBlocks().getBoundingBox(new StructurePlaceSettings(), BlockPos.ZERO));
                    virtualLevel.setBounds(bounds);
                    pkt.internalBlocks().placeInWorld((ServerLevelAccessor)virtualLevel, BlockPos.ZERO, BlockPos.ZERO, new StructurePlaceSettings().setKnownShape(true), RandomSource.create(), 2);
                    BakedLevel bakedLevel = LevelBakery.bakeVertices((Level)virtualLevel, (AABB)bounds, (Vector3f)new Vector3f());
                    return bakedLevel;
                });
                mrs.updateSceneRenderer(setup);
            }
        }
    }
}

