/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.worldgen.decorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.allthemods.allthemons.registry.AllTheMonsRegistrator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class ApricornDecorator
extends TreeDecorator {
    public static final MapCodec<ApricornDecorator> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BlockStateProvider.CODEC.listOf().fieldOf("apricorns").forGetter(ApricornDecorator::getApricorns), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(ApricornDecorator::getProbability)).apply((Applicative)builder, ApricornDecorator::new));
    private static final Direction WORLDGEN_FACING = Direction.SOUTH;
    private static final Direction[] SPAWN_DIRECTIONS = (Direction[])Direction.Plane.HORIZONTAL.stream().filter(p_202307_ -> p_202307_ != WORLDGEN_FACING.getOpposite()).toArray(Direction[]::new);
    private final List<BlockStateProvider> apricorns;
    private final float probability;

    public ApricornDecorator(List<BlockStateProvider> apricorns, float probability) {
        this.apricorns = apricorns;
        this.probability = probability;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)AllTheMonsRegistrator.APRICORN_DECORATOR.get();
    }

    public List<BlockStateProvider> getApricorns() {
        return this.apricorns;
    }

    public float getProbability() {
        return this.probability;
    }

    public void place(TreeDecorator.Context context) {
        context.leaves().forEach(pos -> {
            if (context.isAir(pos.west())) {
                this.addApricorn(pos.west(), Direction.EAST, context);
            }
            if (context.isAir(pos.east())) {
                this.addApricorn(pos.east(), Direction.WEST, context);
            }
            if (context.isAir(pos.north())) {
                this.addApricorn(pos.north(), Direction.SOUTH, context);
            }
            if (context.isAir(pos.south())) {
                this.addApricorn(pos.south(), Direction.NORTH, context);
            }
        });
    }

    private void addApricorn(BlockPos pos, Direction facing, TreeDecorator.Context context) {
        if (!(context.random().nextFloat() >= this.probability)) {
            context.setBlock(pos, (BlockState)((BlockState)this.apricorns.get(context.random().nextInt(this.apricorns.size())).getState(context.random(), pos).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing)).setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(context.random().nextInt(4))));
        }
    }
}

