/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.util;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.egg.EggGroup;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class MonUtil {
    public static PokemonEntity spawnPokemon(ServerLevel serverLevel, BlockPos pos, String species, int level) {
        return MonUtil.spawnPokemon(serverLevel, pos, ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)species), level);
    }

    public static PokemonEntity spawnPokemon(ServerLevel serverLevel, BlockPos pos, ResourceLocation species, int level) {
        return MonUtil.spawnPokemon(serverLevel, pos, species, level, null, null, null);
    }

    public static PokemonEntity spawnPokemon(ServerLevel serverLevel, BlockPos pos, ResourceLocation species, int level, @Nullable String nature, @Nullable List<MoveTemplate> moves, @Nullable Map<String, Integer> ivs) {
        PokemonProperties properties = MonUtil.getProperties(species, level, nature, moves, ivs);
        return MonUtil.spawnPokemon(serverLevel, pos, properties);
    }

    public static PokemonEntity spawnPokemon(ServerLevel serverLevel, BlockPos pos, PokemonProperties properties) {
        PokemonEntity pokemonEntity = properties.createEntity((Level)serverLevel);
        pokemonEntity.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), pokemonEntity.getYRot(), pokemonEntity.getXRot());
        pokemonEntity.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(pos), MobSpawnType.SPAWN_EGG, null);
        if (serverLevel.addFreshEntity((Entity)pokemonEntity)) {
            return pokemonEntity;
        }
        return null;
    }

    public static PokemonProperties getProperties(ResourceLocation species, int level, @Nullable String nature, @Nullable List<MoveTemplate> moves, @Nullable Map<String, Integer> ivs) {
        String moveList = moves != null ? "moves=\"" + moves.stream().map(MoveTemplate::getName).collect(Collectors.joining(",")) + "\"" : "";
        String ivList = ivs != null ? ivs.entrySet().stream().map(e -> (String)e.getKey() + "_iv=" + String.valueOf(e.getValue())).collect(Collectors.joining(" ")) : "";
        return PokemonProperties.Companion.parse("species=\"" + String.valueOf(species) + "\" level=" + level + (String)(nature != null ? " nature=\"" + nature + "\" " : " ") + moveList + " " + ivList);
    }

    public static boolean arePokemonBreedable(Pokemon parent1, Pokemon parent2) {
        if (MonUtil.hasDisallowedLabel(parent1) || MonUtil.hasDisallowedLabel(parent2)) {
            return false;
        }
        boolean isDitto1 = parent1.getSpecies().getEggGroups().contains(EggGroup.DITTO);
        if (isDitto1) {
            return false;
        }
        boolean hasDitto = parent2.getSpecies().getEggGroups().contains(EggGroup.DITTO);
        if (!MonUtil.hasSharedEggGroup(parent1, parent2) && !hasDitto) {
            return false;
        }
        if (parent1.getGender().equals((Object)Gender.GENDERLESS) && !hasDitto) {
            return false;
        }
        return !parent1.getGender().equals((Object)parent2.getGender()) || hasDitto;
    }

    private static boolean hasDisallowedLabel(Pokemon pokemon) {
        return pokemon.hasLabels(new String[]{"baby"}) || pokemon.hasLabels(new String[]{"mythical"}) || pokemon.hasLabels(new String[]{"ultra_beast"}) || pokemon.hasLabels(new String[]{"paradox"}) || pokemon.hasLabels(new String[]{"legendary"});
    }

    private static boolean hasSharedEggGroup(Pokemon parent1, Pokemon parent2) {
        if (!parent1.getSpecies().getEggGroups().contains(EggGroup.UNDISCOVERED) && !parent2.getSpecies().getEggGroups().contains(EggGroup.UNDISCOVERED)) {
            for (EggGroup eggGroup : parent1.getSpecies().getEggGroups()) {
                if (!parent2.getSpecies().getEggGroups().contains(eggGroup) || eggGroup.equals((Object)EggGroup.DITTO)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBirdPokemon(Pokemon pokemon) {
        ArrayList<String> BIRBS = new ArrayList<String>(){
            {
                this.add("Pidgey");
                this.add("Pidgeotto");
                this.add("Pidgeot");
                this.add("Spearow");
                this.add("Fearow");
                this.add("Doduo");
                this.add("Dodrio");
                this.add("Natu");
                this.add("Archen");
                this.add("Archeops");
                this.add("Ducklett");
                this.add("Swanna");
                this.add("Rookidee");
                this.add("Wattrel");
                this.add("Kilowattrel");
                this.add("Bombirdier");
                this.add("Pidove");
                this.add("Tranquill");
                this.add("Unfezant");
                this.add("Taillow");
                this.add("Swellow");
                this.add("Wingull");
                this.add("Pelipper");
                this.add("Fletchling");
                this.add("Fletchinder");
                this.add("Talonflame");
                this.add("Rowlet");
                this.add("Dartrix");
                this.add("Decidueye");
                this.add("Pikipek");
                this.add("Trumbeak");
                this.add("Toucannon");
                this.add("Rookidee");
                this.add("Corvisquire");
                this.add("Corviknight");
                this.add("Quaxly");
                this.add("Quaxwell");
                this.add("Quaquaval");
                this.add("Squawkabilly");
                this.add("Torchic");
                this.add("Combusken");
            }
        };
        return BIRBS.contains(pokemon.getSpecies().getName());
    }

    public static int calculateTokenGain(Pokemon[] pokemons) {
        int tokens = 0;
        for (Pokemon pokemon : pokemons) {
            tokens += MonUtil.calculateTokenGain(pokemon);
        }
        return tokens;
    }

    public static int calculateTokenGain(Pokemon pokemon) {
        int tokens = pokemon.getLevel() / 5;
        Species species = pokemon.getSpecies();
        int evoCount = 0;
        while (species.getPreEvolution() != null) {
            species = species.getPreEvolution().getSpecies();
            ++evoCount;
        }
        if (evoCount > 0) {
            tokens *= 10 * evoCount;
        }
        if (pokemon.getShiny()) {
            tokens *= 20;
        }
        if (pokemon.isLegendary() || pokemon.isMythical() || pokemon.isUltraBeast()) {
            tokens *= 20;
        }
        return tokens;
    }

    public static Map<String, List<String>> copperMechanismBalls() {
        return new HashMap<String, List<String>>(){
            {
                this.put("poke", List.of("red", "blank"));
                this.put("roseate", List.of("pink", "blank"));
                this.put("premier", List.of("white", "blank"));
                this.put("heal", List.of("heal", "blank"));
                this.put("cherish", List.of("cherish", "cherish"));
                this.put("verdant", List.of("green", "blank"));
                this.put("slate", List.of("black", "blank"));
                this.put("citrine", List.of("yellow", "blank"));
                this.put("azure", List.of("blue", "blank"));
                this.put("safari", List.of("safari", "blank"));
            }
        };
    }

    public static Map<String, List<String>> ironMechanismaBalls() {
        return new HashMap<String, List<String>>(){
            {
                this.put("park", List.of("park", "blank"));
                this.put("nest", List.of("nest", "blank"));
                this.put("dive", List.of("dive", "blue"));
                this.put("moon", List.of("moon", "blank"));
                this.put("level", List.of("level", "blank"));
                this.put("friend", List.of("friend", "blank"));
                this.put("sport", List.of("sport", "blank"));
                this.put("heavy", List.of("heavy", "blank"));
                this.put("great", List.of("great", "blank"));
                this.put("net", List.of("net", "blank"));
                this.put("lure", List.of("lure", "blank"));
                this.put("fast", List.of("fast", "blank"));
            }
        };
    }

    public static Map<String, List<String>> brassMechanismBalls() {
        return new HashMap<String, List<String>>(){
            {
                this.put("repeat", List.of("repeat", "blank"));
                this.put("luxury", List.of("luxury", "blank", "#c:nuggets/gold"));
                this.put("quick", List.of("quick", "quick"));
                this.put("dusk", List.of("dusk", "dusk"));
                this.put("ultra", List.of("ultra", "blank"));
                this.put("love", List.of("love", "blank"));
                this.put("timer", List.of("timer", "blank"));
            }
        };
    }

    public static Map<String, List<String>> sturdyMechanismBalls() {
        return new HashMap<String, List<String>>(){
            {
                this.put("dream", List.of("dream", "blue", "create:polished_rose_quartz"));
                this.put("beast", List.of("beast", "beast", "#c:nuggets/gold"));
            }
        };
    }

    public static Map<String, List<String>> ancientCopperMechanismBalls() {
        return new HashMap<String, List<String>>(){
            {
                this.put("ancient_poke", List.of("coated_red", "apricorn"));
                this.put("ancient_roseate", List.of("coated_pink", "apricorn"));
                this.put("ancient_ivory", List.of("coated_white", "blank"));
                this.put("ancient_citrine", List.of("coated_yellow", "apricorn"));
                this.put("ancient_feather", List.of("ancient_feather", "apricorn"));
                this.put("ancient_verdant", List.of("coated_green", "apricorn"));
                this.put("ancient_slate", List.of("coated_black", "apricorn"));
                this.put("ancient_heavy", List.of("ancient_heavy", "black"));
                this.put("ancient_azure", List.of("coated_blue", "apricorn"));
            }
        };
    }

    public static Map<String, List<String>> ancientIronMechanismBalls() {
        return new HashMap<String, List<String>>(){
            {
                this.put("ancient_leaden", List.of("ancient_leaden", "black"));
                this.put("ancient_great", List.of("ancient_great", "apricorn"));
                this.put("ancient_wing", List.of("ancient_wing", "apricorn"));
            }
        };
    }

    public static Map<String, List<String>> ancientBrassMechanismBalls() {
        return new HashMap<String, List<String>>(){
            {
                this.put("ancient_jet", List.of("ancient_jet", "apricorn"));
                this.put("ancient_ultra", List.of("ancient_ultra", "blank"));
                this.put("ancient_gigaton", List.of("ancient_gigaton", "black"));
            }
        };
    }
}

