/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.network;

import com.cobblemon.mod.common.api.pasture.PasturePermissions;
import com.cobblemon.mod.common.api.reactive.SettableObservable;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.gui.pc.PCGUI;
import com.cobblemon.mod.common.client.gui.pc.PCGUIConfiguration;
import com.cobblemon.mod.common.client.storage.ClientPC;
import com.cobblemon.mod.common.net.messages.client.pasture.OpenPasturePacket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import net.allthemods.allthemons.client.gui.PikaPowerPCGUIConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record OpenPikaPowerPayload(UUID pcId, UUID pastureId, int limit, List<OpenPasturePacket.PasturePokemonDataDTO> tetheredPokemon, PasturePermissions permissions) implements CustomPacketPayload
{
    public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"open_pika_power");
    public static final CustomPacketPayload.Type<OpenPikaPowerPayload> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenPikaPowerPayload> CODEC = StreamCodec.of(OpenPikaPowerPayload::encode, OpenPikaPowerPayload::decode);

    public static void encode(@NotNull RegistryFriendlyByteBuf buffer, OpenPikaPowerPayload packet) {
        buffer.writeUUID(packet.pcId);
        buffer.writeUUID(packet.pastureId);
        buffer.writeInt(packet.limit);
        buffer.writeInt(packet.tetheredPokemon.size());
        for (OpenPasturePacket.PasturePokemonDataDTO tethered : packet.tetheredPokemon) {
            tethered.encode(buffer);
        }
        packet.permissions.encode(buffer);
    }

    public static OpenPikaPowerPayload decode(RegistryFriendlyByteBuf buffer) {
        UUID pcId = buffer.readUUID();
        UUID pastureId = buffer.readUUID();
        int limit = buffer.readInt();
        ArrayList<OpenPasturePacket.PasturePokemonDataDTO> dtos = new ArrayList<OpenPasturePacket.PasturePokemonDataDTO>();
        IntStream.range(0, buffer.readInt()).forEach(i -> dtos.add(OpenPasturePacket.PasturePokemonDataDTO.Companion.decode(buffer)));
        PasturePermissions permissions = PasturePermissions.Companion.decode(buffer);
        return new OpenPikaPowerPayload(pcId, pastureId, limit, dtos, permissions);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static class Handler {
        public static void handle(OpenPikaPowerPayload packet, IPayloadContext context) {
            PikaPowerPCGUIConfiguration pcConfiguration = new PikaPowerPCGUIConfiguration(packet.pastureId, packet.limit, (SettableObservable<List<OpenPasturePacket.PasturePokemonDataDTO>>)new SettableObservable(packet.tetheredPokemon), packet.permissions);
            Minecraft.getInstance().setScreen((Screen)new PCGUI((ClientPC)CobblemonClient.INSTANCE.getStorage().getPcStores().get(packet.pcId), CobblemonClient.INSTANCE.getStorage().getParty(), (PCGUIConfiguration)pcConfiguration, CobblemonClient.INSTANCE.getLastPcBoxViewed(), new HashSet()));
        }
    }
}

