/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.mixin.cobblemon;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.egg.EggGroup;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.allthemods.allthemons.Config;
import net.allthemods.allthemons.common.block.PokemonEggBlock;
import net.allthemods.allthemons.common.block.entity.PokemonEggBlockEntity;
import net.allthemods.allthemons.registry.AllTheMonsRegistrator;
import net.allthemods.allthemons.util.MonUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonPastureBlockEntity.class})
public class MixinPokemonPastureBlockEntity
extends BlockEntity {
    @Unique
    int allthemons$breedCooldown = 10;
    @Final
    @Shadow
    private List<PokemonPastureBlockEntity.Tethering> tetheredPokemon;

    public MixinPokemonPastureBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Inject(at={@At(value="RETURN")}, method={"checkPokemon"})
    public void extraActionsPokemon(CallbackInfo ci) {
        --this.allthemons$breedCooldown;
        if (this.getLevel() != null) {
            ArrayList breedablePairs = new ArrayList();
            this.tetheredPokemon.forEach(tethering -> {
                PokemonEntity entity;
                if (tethering.getPokemon() != null && (entity = tethering.getPokemon().getEntity()) != null) {
                    if (entity.onGround() && this.getLevel().random.nextFloat() < 0.01f && MonUtil.isBirdPokemon(tethering.getPokemon())) {
                        entity.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.getLevel().random.nextFloat() - this.getLevel().random.nextFloat()) * 0.2f + 1.0f);
                        entity.spawnAtLocation((ItemLike)Items.EGG);
                        entity.gameEvent((Holder)GameEvent.ENTITY_PLACE);
                    }
                    if (this.allthemons$breedCooldown < 0) {
                        this.tetheredPokemon.forEach(tethering2 -> {
                            if (tethering2.getPokemon() != null && tethering2.getPokemon().getEntity() != null && !tethering2.getPokemon().getEntity().getUUID().equals(entity.getUUID()) && MonUtil.arePokemonBreedable(tethering.getPokemon(), tethering2.getPokemon())) {
                                if (tethering.getPokemon().getGender().equals((Object)Gender.FEMALE) || tethering2.getPokemon().getSpecies().getEggGroups().contains(EggGroup.DITTO)) {
                                    breedablePairs.add(Pair.of((Object)tethering.getPokemon(), (Object)tethering2.getPokemon()));
                                } else {
                                    breedablePairs.add(Pair.of((Object)tethering2.getPokemon(), (Object)tethering.getPokemon()));
                                }
                            }
                        });
                    }
                }
            });
            if (!breedablePairs.isEmpty()) {
                PokemonEntity eggLayerEntity;
                Pair pair = (Pair)breedablePairs.get(this.getLevel().random.nextInt(breedablePairs.size()));
                PokemonEntity pokemonEntity = eggLayerEntity = ((Pokemon)pair.getFirst()).getGender().equals((Object)Gender.MALE) ? ((Pokemon)pair.getSecond()).getEntity() : ((Pokemon)pair.getFirst()).getEntity();
                if (eggLayerEntity != null) {
                    BlockPos eggPos = eggLayerEntity.blockPosition();
                    if (!eggLayerEntity.onGround()) {
                        for (int i = 1; i < 5; ++i) {
                            if (!this.getLevel().getBlockState(eggPos.below(i + 1)).isSolid() || !this.getLevel().getBlockState(eggPos.below(i)).canBeReplaced()) continue;
                            eggPos = eggPos.below(i);
                        }
                    }
                    if (this.getLevel().getBlockState(eggPos.below()).isSolid() && this.getLevel().getBlockState(eggPos).canBeReplaced()) {
                        int eggLevel = Mth.lerpInt((float)(1.0f - (float)((Pokemon)pair.getFirst()).getSpecies().getCatchRate() / 255.0f), (int)1, (int)5);
                        this.getLevel().setBlockAndUpdate(eggPos, (BlockState)((Block)AllTheMonsRegistrator.POKEMON_EGG_BLOCK.get()).defaultBlockState().setValue((Property)PokemonEggBlock.LEVEL, (Comparable)Integer.valueOf(eggLevel)));
                        eggLayerEntity.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.getLevel().random.nextFloat() - this.getLevel().random.nextFloat()) * 0.2f + 1.0f);
                        BlockEntity blockEntity = this.getLevel().getBlockEntity(eggPos);
                        if (blockEntity instanceof PokemonEggBlockEntity) {
                            PokemonEggBlockEntity eggBlockEntity = (PokemonEggBlockEntity)blockEntity;
                            eggBlockEntity.setParents((Pokemon)pair.getFirst(), (Pokemon)pair.getSecond(), eggLevel);
                        }
                        if (eggPos.getY() == eggLayerEntity.blockPosition().getY()) {
                            eggLayerEntity.moveTo(eggLayerEntity.position().add(0.0, 0.8125, 0.0));
                        }
                        this.allthemons$breedCooldown = Config.breedingCooldown / Cobblemon.config.getPastureBlockUpdateTicks() / breedablePairs.size();
                    }
                }
            } else if (this.allthemons$breedCooldown < 0) {
                this.allthemons$breedCooldown = 20;
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"saveAdditional"})
    public void save(CompoundTag nbt, HolderLookup.Provider registryLookup, CallbackInfo ci) {
        nbt.putInt("breedCooldown", this.allthemons$breedCooldown);
    }

    @Inject(at={@At(value="RETURN")}, method={"loadAdditional"})
    public void load(CompoundTag nbt, HolderLookup.Provider registryLookup, CallbackInfo ci) {
        this.allthemons$breedCooldown = nbt.contains("breedCooldown") ? nbt.getInt("breedCooldown") : 10;
    }
}

