/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.event;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.gitlab.srcmc.rctapi.api.RCTApi;
import com.gitlab.srcmc.rctapi.api.battle.BattleState;
import com.gitlab.srcmc.rctapi.api.events.Events;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerPlayer;
import com.gitlab.srcmc.rctmod.ModRegistries;
import com.mojang.brigadier.CommandDispatcher;
import com.thevortex.allthemodium.registry.ModRegistry;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.allthemods.allthemons.Config;
import net.allthemods.allthemons.commands.AdditionalTrainerCommands;
import net.allthemods.allthemons.registry.AllTheMonsRegistrator;
import net.allthemods.allthemons.util.MonUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

@EventBusSubscriber(modid="allthemons")
public class EventHandler {
    private static final int NOVICE = 1;
    private static final int APPRENTICE = 2;
    private static final int JOURNEYMAN = 3;
    private static final int EXPERT = 4;
    private static final int MASTER = 5;

    @SubscribeEvent
    static void onCommonSetup(FMLCommonSetupEvent event) {
        AllTheMonsRegistrator.associateBalls();
        CobblemonEvents.SHINY_CHANCE_CALCULATION.subscribe(Priority.NORMAL, e -> {
            e.addModificationFunction((chance, serverPlayer, pokemon) -> {
                if (serverPlayer != null && serverPlayer.getInventory().contains(stack -> stack.is((Item)AllTheMonsRegistrator.PIKASTAR.get()))) {
                    return Float.valueOf(chance.floatValue() / 10.0f);
                }
                return chance;
            });
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_RELEASED_EVENT_POST.subscribe(Priority.NORMAL, e -> {
            int tokens = MonUtil.calculateTokenGain(e.getPokemon());
            e.getPlayer().addItem(new ItemStack((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), tokens));
            e.getPlayer().displayClientMessage((Component)Component.translatable((String)"allthemons.chat.pokemon_released", (Object[])new Object[]{tokens, e.getPokemon().getSpecies().getName()}), false);
            return Unit.INSTANCE;
        });
        RCTApi.getInstance((String)"rctmod").getEventContext().register(Events.BATTLE_ENDED, e -> ((BattleState)e.getValue()).getWinners().forEach(trainer -> {
            if (trainer instanceof TrainerPlayer) {
                TrainerPlayer trainerPlayer = (TrainerPlayer)trainer;
                int tokens = 10 + ((BattleState)e.getValue()).getLosers().stream().map(loser -> MonUtil.calculateTokenGain(loser.getTeam())).mapToInt(Integer::intValue).sum() / ((BattleState)e.getValue()).getWinners().size();
                if (!trainerPlayer.getPlayer().addItem(new ItemStack((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), tokens))) {
                    Block.popResourceFromFace((Level)trainerPlayer.getPlayer().level(), (BlockPos)trainerPlayer.getPlayer().blockPosition(), (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), tokens));
                }
                trainerPlayer.getPlayer().displayClientMessage((Component)Component.translatable((String)"allthemons.chat.battle_won", (Object[])new Object[]{((BattleState)e.getValue()).getLosers().stream().map(loser -> loser.getName().getLiteral()).collect(Collectors.joining(" and ")), tokens}).withStyle(ChatFormatting.ITALIC), false);
            }
        }));
    }

    @SubscribeEvent
    static void registerCommands(RegisterCommandsEvent event) {
        AdditionalTrainerCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    static void babySpawnEvent(BabyEntitySpawnEvent event) {
        if (event.getChild() != null) {
            event.getChild().spawnType = MobSpawnType.BREEDING;
        }
    }

    @SubscribeEvent
    static void onTooltipEvent(ItemTooltipEvent event) {
        if (event.getItemStack().is(CobblemonItemTags.POKE_BALLS) && event.getItemStack().getDescriptionId().contains("allthemons")) {
            event.getToolTip().add(Component.translatable((String)(event.getItemStack().getDescriptionId() + ".tooltip")).withStyle(ChatFormatting.GRAY));
            return;
        }
        if (event.getItemStack().is((Item)ModRegistries.Items.TRAINER_CARD.get())) {
            event.getToolTip().add(Component.translatable((String)"item.modifiers.hand").withStyle(ChatFormatting.GRAY));
            event.getToolTip().add(CommonComponents.space().append((Component)Component.translatable((String)(event.getItemStack().getDescriptionId() + ".tooltip")).withStyle(ChatFormatting.DARK_GREEN)));
        }
    }

    @SubscribeEvent
    static void onEntitySpawn(EntityJoinLevelEvent event) {
        Level level;
        if (Config.replaceAnimalSpawn.booleanValue() && !event.loadedFromDisk() && (level = event.getLevel()) instanceof ServerLevel) {
            Mob entity;
            ServerLevel serverLevel = (ServerLevel)level;
            level = event.getEntity();
            if (level instanceof Mob && EventHandler.isValidSpawnType((entity = (Mob)level).getSpawnType()) && entity.getType().is(AllTheMonsRegistrator.REPLACEABLE_ANIMALS)) {
                BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
                executor.tell((Runnable)new TickTask(0, () -> {
                    if (entity.getType().equals(EntityType.COW)) {
                        MonUtil.spawnPokemon(serverLevel, entity.blockPosition(), "miltank", serverLevel.random.nextInt(5, 15));
                    } else if (entity.getType().equals(EntityType.SHEEP)) {
                        MonUtil.spawnPokemon(serverLevel, entity.blockPosition(), "wooloo", serverLevel.random.nextInt(5, 15));
                    } else if (entity.getType().equals(EntityType.CHICKEN)) {
                        MonUtil.spawnPokemon(serverLevel, entity.blockPosition(), serverLevel.random.nextBoolean() ? "pidgey" : "spearow", serverLevel.random.nextInt(5, 10));
                    } else if (entity.getType().equals(EntityType.PIG)) {
                        MonUtil.spawnPokemon(serverLevel, entity.blockPosition(), "lechonk", serverLevel.random.nextInt(5, 15));
                    } else if (entity.getType().equals(EntityType.RABBIT)) {
                        MonUtil.spawnPokemon(serverLevel, entity.blockPosition(), entity.getRandom().nextBoolean() ? "bunnelby" : "buneary", serverLevel.random.nextInt(5, 15));
                    } else if (!entity.getType().equals(EntityType.SQUID) && !entity.getType().equals(EntityType.GLOW_SQUID) && entity.getType().equals(ModRegistry.PIGLICH.get())) {
                        MonUtil.spawnPokemon(serverLevel, entity.blockPosition(), "piglich", serverLevel.random.nextInt(25, 55));
                    }
                    entity.discard();
                }));
            }
        }
    }

    private static boolean isValidSpawnType(MobSpawnType type) {
        return type == null || type.equals((Object)MobSpawnType.NATURAL) || type.equals((Object)MobSpawnType.CHUNK_GENERATION) || type.equals((Object)MobSpawnType.STRUCTURE);
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType().equals(AllTheMonsRegistrator.TRADER.get())) {
            ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 12), Optional.of(new ItemCost((ItemLike)CobblemonItems.RED_APRICORN, 1)), new ItemStack((ItemLike)CobblemonItems.POKE_BALL), 1, 64, 6, 0.2f));
            ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 16), Optional.empty(), new ItemStack((ItemLike)CobblemonItems.POTION), 1, 64, 6, 0.2f));
            ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)CobblemonItems.RED_APRICORN, 4), Optional.empty(), new ItemStack(AllTheMonsRegistrator.TOKEN_ITEM, 4), 1, 16, 4, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 24), Optional.of(new ItemCost((ItemLike)CobblemonItems.BLUE_APRICORN, 2)), new ItemStack((ItemLike)CobblemonItems.LURE_BALL), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 24), Optional.of(new ItemCost((ItemLike)CobblemonItems.GREEN_APRICORN, 2)), new ItemStack((ItemLike)CobblemonItems.FRIEND_BALL), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 24), Optional.of(new ItemCost((ItemLike)CobblemonItems.WHITE_APRICORN, 2)), new ItemStack((ItemLike)CobblemonItems.FAST_BALL), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 24), Optional.of(new ItemCost((ItemLike)CobblemonItems.YELLOW_APRICORN, 2)), new ItemStack((ItemLike)CobblemonItems.MOON_BALL), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(3)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 24), Optional.of(new ItemCost((ItemLike)CobblemonItems.BLACK_APRICORN, 2)), new ItemStack((ItemLike)CobblemonItems.HEAVY_BALL), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(3)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 24), Optional.of(new ItemCost((ItemLike)CobblemonItems.PINK_APRICORN, 2)), new ItemStack((ItemLike)CobblemonItems.LOVE_BALL), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(3)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 24), Optional.empty(), new ItemStack((ItemLike)CobblemonItems.REVIVE), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 16), Optional.empty(), new ItemStack((ItemLike)CobblemonItems.RED_APRICORN_SEED), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 16), Optional.empty(), new ItemStack((ItemLike)CobblemonItems.BLUE_APRICORN_SEED), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 16), Optional.empty(), new ItemStack((ItemLike)CobblemonItems.GREEN_APRICORN_SEED), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 16), Optional.empty(), new ItemStack((ItemLike)CobblemonItems.PINK_APRICORN_SEED), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 16), Optional.empty(), new ItemStack((ItemLike)CobblemonItems.WHITE_APRICORN_SEED), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 16), Optional.empty(), new ItemStack((ItemLike)CobblemonItems.YELLOW_APRICORN_SEED), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 16), Optional.empty(), new ItemStack((ItemLike)CobblemonItems.BLACK_APRICORN_SEED), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(5)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 64), Optional.of(new ItemCost((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"allthemodium_apricorn")), 16)), new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"allthemodium_apricorn_seed"))), 1, 4, 12, 0.2f));
            ((List)event.getTrades().get(5)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)AllTheMonsRegistrator.TOKEN_ITEM.get(), 64), Optional.of(new ItemCost((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"vibranium_apricorn")), 16)), new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"vibranium_apricorn_seed"))), 1, 4, 12, 0.2f));
            ((List)event.getTrades().get(5)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)ModRegistry.UNOBTAINIUM_BLOCK.get(), 64), Optional.of(new ItemCost((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"vibranium_apricorn_seed")), 16)), new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"unobtainium_apricorn_seed"))), 1, 4, 12, 0.2f));
        }
    }
}

