/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.datagen.recipe.oritech;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.allthemods.allthemons.util.MonUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import rearth.oritech.api.recipe.AssemblerRecipeBuilder;
import rearth.oritech.api.recipe.AtomicForgeRecipeBuilder;
import rearth.oritech.api.recipe.GrinderRecipeBuilder;
import rearth.oritech.api.recipe.OritechRecipeBuilder;
import rearth.oritech.api.recipe.RefineryRecipeBuilder;

public class OritechRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public OritechRecipeProvider(PackOutput gen, CompletableFuture<HolderLookup.Provider> registries) {
        super(gen, registries);
    }

    public String getName() {
        return "All The Mons Oritech compat recipes";
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        OritechRecipeProvider.baseApricornRecipes(recipeOutput);
        OritechRecipeProvider.baseLidRecipes(recipeOutput);
        OritechRecipeProvider.baseBallRecipes(recipeOutput);
        OritechRecipeProvider.baseMechanisms(recipeOutput);
        for (String material : new String[]{"allthemodium", "vibranium", "unobtainium"}) {
            GrinderRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_apricorn")))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("half_" + material + "_apricorn"))), 2).export(recipeOutput, "half_" + material + "_apricorn", "allthemons");
            AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("half_" + material + "_apricorn")))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_apricorn_bits")))).export(recipeOutput, material + "_apricorn_bits", "allthemons");
            AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemodium", (String)(material + "_plate")))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_ball_base")))).export(recipeOutput, material + "_ball_base", "allthemons");
            AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_ball_base")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemodium", (String)(material + "_nugget")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"shaft"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_ball_base")))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_ball_mechanism")))).export(recipeOutput, material + "_ball_mechanism", "allthemons");
            AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_ball_base")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemodium", (String)(material + "_ingot")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"shaft"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_ball_base")))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("ancient_" + material + "_ball_mechanism")))).export(recipeOutput, "ancient_" + material + "_ball_mechanism", "allthemons");
            if (material.equals("unobtainium")) continue;
            AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blank_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_apricorn_bits")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemodium", (String)(material + "_block")))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_ball_lid")))).export(recipeOutput, material + "_ball_lid", "allthemons");
            AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_ball_lid")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"tumblestone_dust"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"tumblestone_dust"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("ancient_" + material + "_ball_lid")))).export(recipeOutput, "ancient_" + material + "_ball_lid", "allthemons");
            AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_ball_mechanism")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_ball_lid")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blank_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"rods/iron"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(material + "_ball")))).export(recipeOutput, material + "_ball", "allthemons");
            AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("ancient_" + material + "_ball_mechanism")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("ancient_" + material + "_ball_lid")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"apricorn_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"rods/iron"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("ancient_" + material + "_ball")))).export(recipeOutput, "ancient_" + material + "_ball", "allthemons");
        }
        RefineryRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"great_ball_lid"))).fluidInput((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.fromNamespaceAndPath((String)"allthemodium", (String)"soul_lava")), 1000.0f).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"soul_lava_ball_lid"))).export(recipeOutput, "soul_lava_ball_lid", "allthemons");
        RefineryRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"ancient_great_ball_lid"))).fluidInput((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.fromNamespaceAndPath((String)"allthemodium", (String)"soul_lava")), 1000.0f).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"ancient_soul_lava_ball_lid"))).export(recipeOutput, "ancient_soul_lava_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"vibranium_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"unobtainium_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemodium", (String)"unobtainium_block"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"unobtainium_ball_lid"))).export(recipeOutput, "unobtainium_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"ancient_vibranium_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"unobtainium_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemodium", (String)"unobtainium_block"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"ancient_unobtainium_ball_lid"))).export(recipeOutput, "ancient_unobtainium_ball_lid", "allthemons");
        AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"sturdy_ball_mechanism"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"soul_lava_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blank_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"rods/iron"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"soul_lava_ball"))).export(recipeOutput, "soul_lava_ball", "allthemons");
        AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"sturdy_ancient_ball_mechanism"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"ancient_soul_lava_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"apricorn_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"rods/iron"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"ancient_soul_lava_ball"))).export(recipeOutput, "ancient_soul_lava_ball", "allthemons");
        AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"unobtainium_ball_mechanism"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"unobtainium_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"unobtainium_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"rods/iron"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"unobtainium_ball"))).export(recipeOutput, "unobtainium_ball", "allthemons");
        AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"ancient_unobtainium_ball_mechanism"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"ancient_unobtainium_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"ancient_unobtainium_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"rods/iron"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"ancient_unobtainium_ball"))).export(recipeOutput, "ancient_unobtainium_ball", "allthemons");
    }

    private static void baseApricornRecipes(RecipeOutput recipeOutput) {
        for (String material : new String[]{"red", "yellow", "green", "blue", "pink", "black", "white"}) {
            GrinderRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)(material + "_apricorn")))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)("half_" + material + "_apricorn"))), 2).export(recipeOutput, "half_" + material + "_apricorn", "allthemons");
            AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)("half_" + material + "_apricorn")))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_apricorn_bits")))).export(recipeOutput, material + "_apricorn_bits", "allthemons");
        }
    }

    private static void baseLidRecipes(RecipeOutput recipeOutput) {
        for (String material : new String[]{"red", "yellow", "green", "blue", "pink", "black", "white"}) {
            AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blank_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyes/" + material)))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_ball_lid")))).export(recipeOutput, material + "_ball_lid", "allthemons");
            AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_ball_lid")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"tumblestone_dust"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)("coated_" + material + "_ball_lid")))).export(recipeOutput, "coated_" + material + "_ball_lid", "allthemons");
        }
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"great_ball_lid"))).export(recipeOutput, "great_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"coated_blue_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"ancient_great_ball_lid"))).export(recipeOutput, "ancient_great_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"black_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"ultra_ball_lid"))).export(recipeOutput, "ultra_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"coated_black_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"ancient_ultra_ball_lid"))).export(recipeOutput, "ancient_ultra_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"green_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/green"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"safari_ball_lid"))).export(recipeOutput, "safari_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/red"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"fast_ball_lid"))).export(recipeOutput, "fast_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/black"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"level_ball_lid"))).export(recipeOutput, "level_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/cyan"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"lure_ball_lid"))).export(recipeOutput, "lure_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"black_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"heavy_ball_lid"))).export(recipeOutput, "heavy_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"pink_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/pink"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"white_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"love_ball_lid"))).export(recipeOutput, "love_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"green_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/red"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"friend_ball_lid"))).export(recipeOutput, "friend_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/black"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"moon_ball_lid"))).export(recipeOutput, "moon_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"white_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"white_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"sport_ball_lid"))).export(recipeOutput, "sport_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"green_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/cyan"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"part_ball_lid"))).export(recipeOutput, "part_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/cyan"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"black_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"net_ball_lid"))).export(recipeOutput, "net_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/white"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"white_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"dive_ball_lid"))).export(recipeOutput, "dive_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"green_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"nest_ball_lid"))).export(recipeOutput, "nest_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/yellow"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"black_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"repeat_ball_lid"))).export(recipeOutput, "repeat_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"black_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/white"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"timer_ball_lid"))).export(recipeOutput, "timer_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"black_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/yellow"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"luxury_ball_lid"))).export(recipeOutput, "luxury_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"green_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/black"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"dusk_ball_lid"))).export(recipeOutput, "dusk_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"pink_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/white"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"heal_ball_lid"))).export(recipeOutput, "heal_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/yellow"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"yellow_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"quick_ball_lid"))).export(recipeOutput, "quick_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"pink_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"gems/rose_quartz"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"create", (String)"sandpaper"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"dream_ball_lid"))).export(recipeOutput, "dream_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/gold"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/gold"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)"echo_shard"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"beast_ball_lid"))).export(recipeOutput, "beast_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/black"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"red_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"cherish_ball_lid"))).export(recipeOutput, "cherish_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"sky_tumblestone_dust"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"light_coated_blue_ball_lid"))).export(recipeOutput, "light_coated_blue_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"black_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"black_tumblestone_dust"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"dense_coated_black_ball_lid"))).export(recipeOutput, "dense_coated_black_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"light_coated_blue_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/blue"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"white_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"ancient_feather_ball_lid"))).export(recipeOutput, "ancient_feather_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"light_coated_blue_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"ancient_wing_ball_lid"))).export(recipeOutput, "ancient_wing_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"light_coated_blue_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"white_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"blue_apricorn_bits"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/blue"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"ancient_jet_ball_lid"))).export(recipeOutput, "ancient_jet_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"dense_coated_black_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/gray"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"black_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"ancient_heavy_ball_lid"))).export(recipeOutput, "ancient_heavy_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"dense_coated_black_ball_lid"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"white_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"black_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"ancient_leaden_ball_lid"))).export(recipeOutput, "ancient_leaden_ball_lid", "allthemons");
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"dense_coated_black_ball_lid"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dyes/white"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"white_apricorn_bits"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"black_apricorn_bits"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"ancient_gigaton_ball_lid"))).export(recipeOutput, "ancient_gigaton_ball_lid", "allthemons");
        GrinderRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"stripped_apricorn_log"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"apricorn_ball_lid")), 4).export(recipeOutput, "apricorn_ball_lid", "allthemons");
    }

    private static void baseBallRecipes(RecipeOutput recipeOutput) {
        MonUtil.copperMechanismBalls().forEach((s, strings) -> OritechRecipeProvider.baseBallRecipe("copper", s, strings, recipeOutput));
        MonUtil.ironMechanismaBalls().forEach((s, strings) -> OritechRecipeProvider.baseBallRecipe("iron", s, strings, recipeOutput));
        MonUtil.brassMechanismBalls().forEach((s, strings) -> OritechRecipeProvider.baseBallRecipe("brass", s, strings, recipeOutput));
        MonUtil.sturdyMechanismBalls().forEach((s, strings) -> OritechRecipeProvider.baseBallRecipe("sturdy", s, strings, recipeOutput));
        MonUtil.ancientCopperMechanismBalls().forEach((s, strings) -> OritechRecipeProvider.baseBallRecipe("copper_ancient", s, strings, recipeOutput));
        MonUtil.ancientIronMechanismBalls().forEach((s, strings) -> OritechRecipeProvider.baseBallRecipe("iron_ancient", s, strings, recipeOutput));
        MonUtil.ancientBrassMechanismBalls().forEach((s, strings) -> OritechRecipeProvider.baseBallRecipe("brass_ancient", s, strings, recipeOutput));
    }

    private static void baseBallRecipe(String mechanism, String name, List<String> strings, RecipeOutput recipeOutput) {
        if (strings.size() > 2) {
            OritechRecipeBuilder builder = AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(mechanism + "_ball_mechanism")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(strings.getFirst() + "_ball_lid")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(strings.get(1) + "_ball_lid"))));
            if (strings.getLast().contains("#")) {
                builder.input(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)strings.getLast().replace("#", ""))));
            } else {
                builder.input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)strings.getLast())));
            }
            builder.result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)(name + "_ball")))).export(recipeOutput, name + "_ball", "allthemons");
        } else {
            AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(mechanism + "_ball_mechanism")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(strings.getFirst() + "_ball_lid")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(strings.getLast() + "_ball_lid")))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"rods/iron"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)(name + "_ball")))).export(recipeOutput, name + "_ball", "allthemons");
        }
    }

    private static void baseMechanisms(RecipeOutput recipeOutput) {
        for (String material : new String[]{"copper", "iron", "brass"}) {
            AtomicForgeRecipeBuilder.build().input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("nuggets/" + material)))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_ball_base")))).export(recipeOutput, material + "_ball_base", "allthemons");
            AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_ball_base")))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("nuggets/" + material)))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"shaft"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_ball_base")))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_ball_mechanism")))).export(recipeOutput, material + "_ball_mechanism", "allthemons");
            AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_ball_base")))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"andesite_alloy"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"shaft"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_ball_base")))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_ancient_ball_mechanism")))).export(recipeOutput, material + "_ancient_ball_mechanism", "allthemons");
        }
        AtomicForgeRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"sturdy_sheet"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"sturdy_ball_base"))).export(recipeOutput, "sturdy_ball_base", "allthemons");
        AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"sturdy_ball_base"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"andesite_alloy"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"shaft"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"sturdy_ball_base"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"sturdy_ball_mechanism"))).export(recipeOutput, "sturdy_ball_mechanism", "allthemons");
        AssemblerRecipeBuilder.build().input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"sturdy_ball_base"))).input(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"gems/rose_quartz"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"shaft"))).input((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"sturdy_ball_base"))).result((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"sturdy_ancient_ball_mechanism"))).export(recipeOutput, "sturdy_ancient_ball_mechanism", "allthemons");
    }
}

