/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.datagen.recipe.mekanism;

import com.jerry.mekmm.api.datagen.recipe.builder.StamperRecipeBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.concurrent.CompletableFuture;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.datagen.recipe.builder.ItemStackChemicalToItemStackRecipeBuilder;
import mekanism.api.datagen.recipe.builder.ItemStackToChemicalRecipeBuilder;
import mekanism.api.datagen.recipe.builder.SawmillRecipeBuilder;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.allthemods.allthemons.datagen.recipe.mekanism.LatheRecipeBuilder;
import net.allthemods.allthemons.registry.AllTheMonsRegistrator;
import net.allthemods.allthemons.registry.MekanismCompatRegistrator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.registries.DeferredHolder;

public class MechanismRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public MechanismRecipeProvider(PackOutput gen, CompletableFuture<HolderLookup.Provider> registries) {
        super(gen, registries);
    }

    public String getName() {
        return "All The Mons Mekanism compat recipes";
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        MechanismRecipeProvider.baseApricornRecipes(recipeOutput);
        MechanismRecipeProvider.baseMechanisms(recipeOutput);
        for (Pair pair : new Pair[]{Pair.of((Object)"", (Object)"standard"), Pair.of((Object)"sky_", (Object)"light"), Pair.of((Object)"black_", (Object)"dense")}) {
            DeferredHolder chemical = MekanismCompatRegistrator.CHEMICALS.getEntries().stream().filter(c -> c.getId().getPath().equals((String)chem.getSecond() + "_tumblestone")).findFirst().get();
            ItemStackToChemicalRecipeBuilder.chemicalConversion((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)((String)pair.getFirst() + "tumblestone")))), (int)1)), (ChemicalStack)new ChemicalStack((Holder)chemical, 800L)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/chemical_conversion/" + (String)pair.getSecond() + "_tumblestone")));
            ItemStackToChemicalRecipeBuilder.chemicalConversion((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)((String)pair.getFirst() + "tumblestone_dust")))), (int)1)), (ChemicalStack)new ChemicalStack((Holder)chemical, 200L)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/chemical_conversion/" + (String)pair.getSecond() + "_tumblestone_from_dust")));
            ItemStackToChemicalRecipeBuilder.oxidizing((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)((String)pair.getFirst() + "tumblestone")))), (int)1)), (ChemicalStack)new ChemicalStack((Holder)chemical, 800L)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/oxidizing/" + (String)pair.getSecond() + "_tumblestone")));
            ItemStackToChemicalRecipeBuilder.oxidizing((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)((String)pair.getFirst() + "tumblestone_dust")))), (int)1)), (ChemicalStack)new ChemicalStack((Holder)chemical, 200L)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/oxidizing/" + (String)pair.getSecond() + "_tumblestone_from_dust")));
        }
        ItemStackChemicalToItemStackRecipeBuilder.metallurgicInfusing((ItemStackIngredient)IngredientCreatorAccess.item().from((ItemLike)AllTheMonsRegistrator.UNOBTAINIUM_BALL_LID.get()), (ChemicalStackIngredient)IngredientCreatorAccess.chemicalStack().from((Chemical)MekanismCompatRegistrator.STANDARD_TUMBLESTONE.get(), 400), (ItemStack)new ItemStack((ItemLike)AllTheMonsRegistrator.ANCIENT_UNOBTAINIUM_BALL_LID.get()), (boolean)false).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"mekanism/infusing/ancient_unobtainium_ball_lid"));
        ItemStackChemicalToItemStackRecipeBuilder.metallurgicInfusing((ItemStackIngredient)IngredientCreatorAccess.item().from((ItemLike)AllTheMonsRegistrator.VIBRANIUM_BALL_LID.get()), (ChemicalStackIngredient)IngredientCreatorAccess.chemicalStack().from((Chemical)MekanismCompatRegistrator.STANDARD_TUMBLESTONE.get(), 400), (ItemStack)new ItemStack((ItemLike)AllTheMonsRegistrator.ANCIENT_VIBRANIUM_BALL_LID.get()), (boolean)false).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"mekanism/infusing/ancient_vibranium_ball_lid"));
        for (String string : new String[]{"allthemodium", "vibranium", "unobtainium"}) {
            SawmillRecipeBuilder.sawing((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(string + "_apricorn")))), (int)1)), (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("half_" + string + "_apricorn"))), 2)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/sawing/half_" + string + "_apricorn")));
            SawmillRecipeBuilder.sawing((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("half_" + string + "_apricorn")))), (int)1)), (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(string + "_apricorn_bits"))), 1)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/sawing/half_" + string + "_apricorn_bits")));
            StamperRecipeBuilder.stamping((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemodium", (String)(string + "_plate")))), (int)1)), (ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"rubber_stamp_lid"))), (int)1)), (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(string + "_stamped_plate_lid"))), 1)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/stamping/" + string + "_stamped_plate_lid")));
            LatheRecipeBuilder.lathe(ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(string + "_stamped_plate_lid")))), (int)1)), new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(string + "_ball_base"))), 1)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/lathe/" + string + "_ball_base")));
        }
    }

    private static void baseApricornRecipes(RecipeOutput recipeOutput) {
        for (String material : new String[]{"red", "yellow", "green", "blue", "pink", "black", "white"}) {
            SawmillRecipeBuilder.sawing((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)(material + "_apricorn")))), (int)1)), (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)("half_" + material + "_apricorn"))), 2)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/sawing/half_" + material + "_apricorn")));
            SawmillRecipeBuilder.sawing((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)("half_" + material + "_apricorn")))), (int)1)), (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_apricorn_bits"))), 1)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/sawing/half_" + material + "_apricorn_bits")));
        }
    }

    private static void baseMechanisms(RecipeOutput recipeOutput) {
        for (String material : new String[]{"copper", "iron", "brass"}) {
            StamperRecipeBuilder.stamping((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("nuggets/" + material))), (int)1)), (ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"rubber_stamp_lid"))), (int)1)), (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)("stamped_" + material + "_nugget_lid"))), 1)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/stamping/stamped_" + material + "_nugget_lid")));
            LatheRecipeBuilder.lathe(ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)("stamped_" + material + "_nugget_lid")))), (int)1)), new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_ball_base"))), 1)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/lathe/" + material + "_ball_base")));
        }
        StamperRecipeBuilder.stamping((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"nuggets/zinc")), (int)1)), (ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"rubber_stamp_lid"))), (int)1)), (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"stamped_zinc_nugget_lid")), 1)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"mekanism/stamping/stamped_zinc_nugget_lid"));
        StamperRecipeBuilder.stamping((ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"sturdy_sheet"))), (int)1)), (ItemStackIngredient)ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"rubber_stamp_lid"))), (int)1)), (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"stamped_sturdy_sheet_lid")), 1)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"mekanism/stamping/stamped_sturdy_sheet_lid"));
        LatheRecipeBuilder.lathe(ItemStackIngredient.of((SizedIngredient)SizedIngredient.of((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"stamped_sturdy_sheet_lid"))), (int)1)), new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)"sturdy_ball_base")), 1)).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"mekanism/lathe/sturdy_ball_base"));
        for (String material : new String[]{"red", "yellow", "green", "blue", "pink", "black", "white"}) {
            ItemStackChemicalToItemStackRecipeBuilder.metallurgicInfusing((ItemStackIngredient)IngredientCreatorAccess.item().from((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)(material + "_ball_lid")))), (ChemicalStackIngredient)IngredientCreatorAccess.chemicalStack().from((Chemical)MekanismCompatRegistrator.STANDARD_TUMBLESTONE.get(), 200), (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"createmonballsoverhaul", (String)("coated_" + material + "_ball_lid")))), (boolean)false).build(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("mekanism/infusing/coated_" + material + "_ball_lid")));
        }
    }
}

