/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.datagen.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;

public class RenderTypedModelTemplate
extends ModelTemplate {
    public static final TextureSlot APRICORN_SLOT = TextureSlot.create((String)"apricorn");
    public static final ModelTemplate CROSS = RenderTypedModelTemplate.create("cross", "cutout", TextureSlot.CROSS);
    public static final ModelTemplate APRICORN = RenderTypedModelTemplate.create(ResourceLocation.parse((String)"allthemons:block/apricorn_stage_3"), "cutout", "", APRICORN_SLOT);
    public static final ModelTemplate[] APRICORNS = new ModelTemplate[]{RenderTypedModelTemplate.create(ResourceLocation.parse((String)"cobblemon:block/apricorn_stage_0"), "cutout", "", new TextureSlot[0]), RenderTypedModelTemplate.create(ResourceLocation.parse((String)"cobblemon:block/apricorn_stage_1"), "cutout", "", new TextureSlot[0]), RenderTypedModelTemplate.create(ResourceLocation.parse((String)"cobblemon:block/apricorn_stage_2"), "cutout", "", new TextureSlot[0])};
    private final ResourceLocation model;
    private final String renderType;

    public RenderTypedModelTemplate(ResourceLocation model, String renderType, String prefix, TextureSlot ... requiredSlots) {
        super(Optional.of(model), prefix.isEmpty() ? Optional.empty() : Optional.of(prefix), requiredSlots);
        this.model = model;
        this.renderType = renderType;
    }

    public JsonObject createBaseTemplate(ResourceLocation modelLocation, Map<TextureSlot, ResourceLocation> modelGetter) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("parent", this.model.toString());
        if (!modelGetter.isEmpty()) {
            JsonObject jsonobject1 = new JsonObject();
            modelGetter.forEach((slot, location) -> jsonobject1.addProperty(slot.getId(), location.toString()));
            jsonobject.add("textures", (JsonElement)jsonobject1);
        }
        jsonobject.addProperty("render_type", this.renderType);
        return jsonobject;
    }

    private static ModelTemplate create(String blockModelLocation, String renderType, TextureSlot ... requiredSlots) {
        return RenderTypedModelTemplate.create(blockModelLocation, renderType, "", requiredSlots);
    }

    private static ModelTemplate create(String blockModelLocation, String renderType, String prefix, TextureSlot ... requiredSlots) {
        return new RenderTypedModelTemplate(ResourceLocation.withDefaultNamespace((String)("block/" + blockModelLocation)), renderType, prefix, requiredSlots);
    }

    private static ModelTemplate create(ResourceLocation blockModelLocation, String renderType, String prefix, TextureSlot ... requiredSlots) {
        return new RenderTypedModelTemplate(blockModelLocation, renderType, prefix, requiredSlots);
    }
}

