/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.datagen;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.allthemods.allthemons.AllTheMons;
import net.allthemods.allthemons.common.block.PokemonEggBlock;
import net.allthemods.allthemons.datagen.model.RenderTypedModelTemplate;
import net.allthemods.allthemons.registry.AllTheMonsRegistrator;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ModelProvider
implements DataProvider {
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();
    static ModelTemplate pokeBall = new ModelTemplate(Optional.of(ResourceLocation.parse((String)"cobblemon:item/poke_ball_model")), Optional.empty(), new TextureSlot[]{TextureSlot.LAYER0});
    static ModelTemplate ancientBall = new ModelTemplate(Optional.of(ResourceLocation.parse((String)"cobblemon:item/ancient_poke_ball_model")), Optional.empty(), new TextureSlot[]{TextureSlot.LAYER0});
    static ModelTemplate unfinishedBallModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"item/unfinished_ball")), Optional.empty(), new TextureSlot[]{TextureSlot.LAYER0});
    static ModelTemplate unfinishedAncientBallModel = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"item/unfinished_ancient_ball")), Optional.empty(), new TextureSlot[]{TextureSlot.LAYER0});

    public ModelProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        HashMap blockModels = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateOutput = blockStateGenerator -> {
            Block block = blockStateGenerator.getBlock();
            BlockStateGenerator blockstategenerator = blockModels.put(block, blockStateGenerator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf(block));
            }
        };
        HashMap itemModels = Maps.newHashMap();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = (resourceLocation, elementSupplier) -> {
            Supplier supplier = itemModels.put(resourceLocation, elementSupplier);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(resourceLocation));
            }
        };
        ModelGenerator generator = new ModelGenerator();
        try {
            generator.registerStatesAndModels(blockStateOutput, modelOutput);
        }
        catch (Exception e) {
            AllTheMons.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        PackOutput.PathProvider blockstatePathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        PackOutput.PathProvider modelPathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        this.generateEggItem((Item)AllTheMonsRegistrator.POKEMON_EGG_ITEM.get(), "item/", modelOutput);
        this.generateCoinItem((Item)AllTheMonsRegistrator.TOKEN_ITEM.get(), "item/", modelOutput);
        this.addBlockItemParentModel((Block)AllTheMonsRegistrator.PIKA_POWER_BASE_BLOCK.get(), "", "_inventory", itemModels);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ALLTHEMODIUM_BALL_ITEM.get(), "cobblemon", "item/poke_balls/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.VIBRANIUM_BALL_ITEM.get(), "cobblemon", "item/poke_balls/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.UNOBTAINIUM_BALL_ITEM.get(), "cobblemon", "item/poke_balls/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.SOUL_LAVA_BALL_ITEM.get(), "cobblemon", "item/poke_balls/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ANCIENT_ALLTHEMODIUM_BALL_ITEM.get(), "cobblemon", "item/poke_balls/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ANCIENT_VIBRANIUM_BALL_ITEM.get(), "cobblemon", "item/poke_balls/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ANCIENT_UNOBTAINIUM_BALL_ITEM.get(), "cobblemon", "item/poke_balls/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ANCIENT_SOUL_LAVA_BALL_ITEM.get(), "cobblemon", "item/poke_balls/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.TOGEPIE.get(), "item/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ANCIENT_DNA_SAMPLE.get(), "item/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.HALF_ALLTHEMODIUM_APRICORN.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.HALF_VIBRANIUM_APRICORN.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.HALF_UNOBTAINIUM_APRICORN.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ALLTHEMODIUM_APRICORN_BITS.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.VIBRANIUM_APRICORN_BITS.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.UNOBTAINIUM_APRICORN_BITS.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ALLTHEMODIUM_BALL_LID.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.VIBRANIUM_BALL_LID.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.UNOBTAINIUM_BALL_LID.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.SOUL_LAVA_BALL_LID.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ANCIENT_ALLTHEMODIUM_BALL_LID.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ANCIENT_VIBRANIUM_BALL_LID.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ANCIENT_UNOBTAINIUM_BALL_LID.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ANCIENT_SOUL_LAVA_BALL_LID.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ALLTHEMODIUM_BALL_MECHANISM.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.VIBRANIUM_BALL_MECHANISM.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.UNOBTAINIUM_BALL_MECHANISM.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ANCIENT_ALLTHEMODIUM_BALL_MECHANISM.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ANCIENT_VIBRANIUM_BALL_MECHANISM.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ANCIENT_UNOBTAINIUM_BALL_MECHANISM.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ALLTHEMODIUM_BALL_BASE.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.VIBRANIUM_BALL_BASE.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.UNOBTAINIUM_BALL_BASE.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.ALLTHEMODIUM_STAMPED_PLATE_LID.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.VIBRANIUM_STAMPED_PLATE_LID.get(), "item/components/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.UNOBTAINIUM_STAMPED_PLATE_LID.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_ALLTHEMODIUM_BALL_LID.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_VIBRANIUM_BALL_LID.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_UNOBTAINIUM_BALL_LID.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_SOUL_LAVA_BALL_LID.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_ANCIENT_ALLTHEMODIUM_BALL_LID.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_ANCIENT_VIBRANIUM_BALL_LID.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_ANCIENT_UNOBTAINIUM_BALL_LID.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_ANCIENT_SOUL_LAVA_BALL_LID.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_ALLTHEMODIUM_BALL_BASE.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_VIBRANIUM_BALL_BASE.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_UNOBTAINIUM_BALL_BASE.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_ALLTHEMODIUM_BALL_MECHANISM.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_VIBRANIUM_BALL_MECHANISM.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_UNOBTAINIUM_BALL_MECHANISM.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_ANCIENT_ALLTHEMODIUM_BALL_MECHANISM.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_ANCIENT_VIBRANIUM_BALL_MECHANISM.get(), "item/components/", modelOutput);
        this.generateUnfinishedFlatItem((Item)AllTheMonsRegistrator.UNFINISHED_ANCIENT_UNOBTAINIUM_BALL_MECHANISM.get(), "item/components/", modelOutput);
        this.addUnfinishedBallModel((Item)AllTheMonsRegistrator.UNFINISHED_ALLTHEMODIUM_BALL.get(), "item/poke_balls/", "", modelOutput);
        this.addUnfinishedBallModel((Item)AllTheMonsRegistrator.UNFINISHED_VIBRANIUM_BALL.get(), "item/poke_balls/", "", modelOutput);
        this.addUnfinishedBallModel((Item)AllTheMonsRegistrator.UNFINISHED_UNOBTAINIUM_BALL.get(), "item/poke_balls/", "", modelOutput);
        this.addUnfinishedBallModel((Item)AllTheMonsRegistrator.UNFINISHED_SOUL_LAVA_BALL.get(), "item/poke_balls/", "", modelOutput);
        this.addUnfinishedBallModel((Item)AllTheMonsRegistrator.UNFINISHED_ANCIENT_ALLTHEMODIUM_BALL.get(), "item/poke_balls/", "", modelOutput);
        this.addUnfinishedBallModel((Item)AllTheMonsRegistrator.UNFINISHED_ANCIENT_VIBRANIUM_BALL.get(), "item/poke_balls/", "", modelOutput);
        this.addUnfinishedBallModel((Item)AllTheMonsRegistrator.UNFINISHED_ANCIENT_UNOBTAINIUM_BALL.get(), "item/poke_balls/", "", modelOutput);
        this.addUnfinishedBallModel((Item)AllTheMonsRegistrator.UNFINISHED_ANCIENT_SOUL_LAVA_BALL.get(), "item/poke_balls/", "", modelOutput);
        this.generateBadgeItem((Item)AllTheMonsRegistrator.ATM_BADGE_BOX.get(), "item/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.THE_VORTEX_BADGE.get(), "item/badges/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.THE_DRUNK_BADGE.get(), "item/badges/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.THE_SKYBLOCK_BADGE.get(), "item/badges/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.THE_LOBSTER_BADGE.get(), "item/badges/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.THE_KITTY_BADGE.get(), "item/badges/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.THE_BATHSALT_BADGE.get(), "item/badges/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.THE_UNKNOWN_BADGE.get(), "item/badges/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.THE_MICROWAVE_BADGE.get(), "item/badges/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.THE_TOBLERONE_BADGE.get(), "item/badges/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.THE_NOTCH_BADGE.get(), "item/badges/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.THE_ARTIST_BADGE.get(), "item/badges/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.THE_RALPH_BADGE.get(), "item/badges/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.PC_ON_A_STICK.get(), "item/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.HEALING_STATION_ON_A_STICK.get(), "item/", modelOutput);
        this.generateFlatItem((Item)AllTheMonsRegistrator.PIKASTAR.get(), "item/", modelOutput);
        this.addBallModel((Item)AllTheMonsRegistrator.ALLTHEMODIUM_BALL_ITEM.get(), "item/poke_balls/", "_model", modelOutput);
        this.addBallModel((Item)AllTheMonsRegistrator.VIBRANIUM_BALL_ITEM.get(), "item/poke_balls/", "_model", modelOutput);
        this.addBallModel((Item)AllTheMonsRegistrator.UNOBTAINIUM_BALL_ITEM.get(), "item/poke_balls/", "_model", modelOutput);
        this.addBallModel((Item)AllTheMonsRegistrator.SOUL_LAVA_BALL_ITEM.get(), "item/poke_balls/", "_model", modelOutput);
        this.addBallModel((Item)AllTheMonsRegistrator.ANCIENT_ALLTHEMODIUM_BALL_ITEM.get(), "item/poke_balls/", "_model", modelOutput);
        this.addBallModel((Item)AllTheMonsRegistrator.ANCIENT_VIBRANIUM_BALL_ITEM.get(), "item/poke_balls/", "_model", modelOutput);
        this.addBallModel((Item)AllTheMonsRegistrator.ANCIENT_UNOBTAINIUM_BALL_ITEM.get(), "item/poke_balls/", "_model", modelOutput);
        this.addBallModel((Item)AllTheMonsRegistrator.ANCIENT_SOUL_LAVA_BALL_ITEM.get(), "item/poke_balls/", "_model", modelOutput);
        for (String name : new String[]{"allthemodium", "vibranium", "unobtainium"}) {
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(name + "_apricorn_seed"))), "item/", modelOutput);
            this.generateFlatItem((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(name + "_apricorn"))), "item/", modelOutput);
        }
        ArrayList output = new ArrayList();
        blockModels.forEach((block, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)blockstatePathProvider.json(BuiltInRegistries.BLOCK.getKey(block)))));
        itemModels.forEach((rLoc, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)modelPathProvider.json(rLoc))));
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void generateFlatItem(Item item, String prefix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), ModelProvider.getFlatItemTextureMap(item, prefix), modelOutput);
    }

    private void generateUnfinishedFlatItem(Item item, String prefix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), ModelProvider.getFlatItemTextureMap(BuiltInRegistries.ITEM.getKey((Object)item).withPath(p -> p.replace("unfinished_", "")), prefix, ""), modelOutput);
    }

    private void generateFlatItem(Item item, String nameSpace, String prefix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), ModelProvider.getFlatItemTextureMap(ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)BuiltInRegistries.ITEM.getKey((Object)item).getPath()), prefix, ""), modelOutput);
    }

    private void addItemParentModel(Item item, ResourceLocation rl, String prefix, String suffix, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(prefix + rl.getPath() + suffix))), itemModels);
    }

    private void addBlockItemParentModel(Block block, String prefix, String suffix, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.BY_BLOCK.get(block);
        if (item != null) {
            ResourceLocation rl = BuiltInRegistries.BLOCK.getKey((Object)block);
            this.addItemParentModel(item, rl, "block/" + prefix, suffix, itemModels);
        }
    }

    private static TextureMapping getFlatItemTextureMap(Item item, String prefix) {
        return ModelProvider.getFlatItemTextureMap(item, prefix, "");
    }

    private static TextureMapping getFlatItemTextureMap(Item item, String prefix, String suffix) {
        return ModelProvider.getFlatItemTextureMap(BuiltInRegistries.ITEM.getKey((Object)item), prefix, suffix);
    }

    private static TextureMapping getFlatItemTextureMap(ResourceLocation resourceLocation, String prefix, String suffix) {
        return new TextureMapping().put(TextureSlot.LAYER0, resourceLocation.withPrefix(prefix).withSuffix(suffix));
    }

    private void addItemModel(Item item, Supplier<JsonElement> supplier, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ResourceLocation resourcelocation;
        if (item != null && !itemModels.containsKey(resourcelocation = ModelLocationUtils.getModelLocation((Item)item))) {
            itemModels.put(resourcelocation, supplier);
        }
    }

    private void generateEggItem(Item item, String suffix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        for (int level = 1; level <= 5; ++level) {
            ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)item).withPrefix("item/").withSuffix("_" + level);
            ModelTemplates.FLAT_ITEM.create(location, ModelProvider.getFlatItemTextureMap(item, suffix, "_level_" + level), modelOutput);
        }
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), ModelProvider.getFlatItemTextureMap(item, suffix), modelOutput, this::createEggMultiTemplate);
    }

    public JsonObject createEggMultiTemplate(ResourceLocation resourceLocation, Map<TextureSlot, ResourceLocation> slotResourceLocationMap) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("parent", "minecraft:item/generated");
        if (!slotResourceLocationMap.isEmpty()) {
            JsonObject textureLocations = new JsonObject();
            slotResourceLocationMap.forEach((textureSlot, resourceLocation1) -> textureLocations.addProperty(textureSlot.getId(), resourceLocation1.withPath(p -> p + "_level_1").toString()));
            jsonobject.add("textures", (JsonElement)textureLocations);
        }
        JsonArray overrides = new JsonArray();
        for (int level = 1; level <= 5; ++level) {
            JsonObject override = new JsonObject();
            JsonObject predicate = new JsonObject();
            predicate.addProperty("level", (Number)level);
            override.add("predicate", (JsonElement)predicate);
            override.addProperty("model", resourceLocation.toString() + "_" + level);
            overrides.add((JsonElement)override);
        }
        jsonobject.add("overrides", (JsonElement)overrides);
        return jsonobject;
    }

    private void generateCoinItem(Item item, String suffix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        for (int level = 1; level <= 5; ++level) {
            ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)item).withPrefix("item/").withSuffix("_" + level);
            ModelTemplates.FLAT_ITEM.create(location, ModelProvider.getFlatItemTextureMap(item, suffix, "_level_" + level), modelOutput);
        }
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), ModelProvider.getFlatItemTextureMap(item, suffix), modelOutput, this::createCoinMultiTemplate);
    }

    public JsonObject createCoinMultiTemplate(ResourceLocation resourceLocation, Map<TextureSlot, ResourceLocation> slotResourceLocationMap) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("parent", "minecraft:item/generated");
        if (!slotResourceLocationMap.isEmpty()) {
            JsonObject textureLocations = new JsonObject();
            slotResourceLocationMap.forEach((textureSlot, resourceLocation1) -> textureLocations.addProperty(textureSlot.getId(), resourceLocation1.withPath(p -> p + "_level_1").toString()));
            jsonobject.add("textures", (JsonElement)textureLocations);
        }
        JsonArray overrides = new JsonArray();
        for (int level = 1; level <= 3; ++level) {
            JsonObject override = new JsonObject();
            JsonObject predicate = new JsonObject();
            predicate.addProperty("level", (Number)level);
            override.add("predicate", (JsonElement)predicate);
            override.addProperty("model", resourceLocation.toString() + "_" + level);
            overrides.add((JsonElement)override);
        }
        jsonobject.add("overrides", (JsonElement)overrides);
        return jsonobject;
    }

    private void generateBadgeItem(Item item, String suffix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item), ModelProvider.getFlatItemTextureMap(item, suffix), modelOutput, this::createBadgeBoxTemplate);
    }

    private JsonObject createBadgeBoxTemplate(ResourceLocation resourceLocation, Map<TextureSlot, ResourceLocation> textureSlotResourceLocationMap) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("parent", "allthemons:item/badge_box_base");
        JsonArray overrides = new JsonArray();
        JsonObject override = new JsonObject();
        JsonObject predicate = new JsonObject();
        predicate.addProperty("open_state", (Number)0);
        override.add("predicate", (JsonElement)predicate);
        override.addProperty("model", "allthemons:item/badge_box_base_open");
        overrides.add((JsonElement)override);
        jsonobject.add("overrides", (JsonElement)overrides);
        return jsonobject;
    }

    private void addBallModel(Item item, String prefix, String suffix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ResourceLocation resourcelocation = ModelLocationUtils.getModelLocation((Item)item).withPath(p -> p + suffix);
        if (resourcelocation.getPath().contains("ancient")) {
            ancientBall.create(resourcelocation, ModelProvider.getFlatItemTextureMap(item, prefix), modelOutput);
        } else {
            pokeBall.create(resourcelocation, ModelProvider.getFlatItemTextureMap(item, prefix), modelOutput);
        }
    }

    private void addUnfinishedBallModel(Item item, String prefix, String suffix, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        ResourceLocation resourcelocation = ModelLocationUtils.getModelLocation((Item)item).withPath(p -> p + suffix);
        if (resourcelocation.getPath().contains("ancient")) {
            unfinishedAncientBallModel.create(resourcelocation, ModelProvider.getFlatItemTextureMap(BuiltInRegistries.ITEM.getKey((Object)item).withPath(p -> p.replace("unfinished_", "")), prefix, ""), modelOutput);
        } else {
            unfinishedBallModel.create(resourcelocation, ModelProvider.getFlatItemTextureMap(BuiltInRegistries.ITEM.getKey((Object)item).withPath(p -> p.replace("unfinished_", "")), prefix, ""), modelOutput);
        }
    }

    public String getName() {
        return "All The Mons Model generator";
    }

    static class ModelGenerator {
        Consumer<BlockStateGenerator> blockStateOutput;
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;

        ModelGenerator() {
        }

        protected void registerStatesAndModels(Consumer<BlockStateGenerator> blockStateOutput, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
            this.blockStateOutput = blockStateOutput;
            this.modelOutput = modelOutput;
            this.createPikapowerBlock((Block)AllTheMonsRegistrator.PIKA_POWER_BASE_BLOCK.get());
            this.createBaseModels();
            for (String name : new String[]{"allthemodium", "vibranium", "unobtainium"}) {
                this.createApricornPlant((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(name + "_apricorn_sapling"))), "apricorns/");
                this.createApricornBlock((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(name + "_apricorn"))));
            }
            ModelTemplate eggTemplate = new ModelTemplate(Optional.of(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"block/pokemon_egg")), Optional.empty(), new TextureSlot[]{TextureSlot.ALL});
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)((Block)AllTheMonsRegistrator.POKEMON_EGG_BLOCK.get())).with(PropertyDispatch.property((Property)PokemonEggBlock.LEVEL).generate(level -> Variant.variant().with(VariantProperties.MODEL, (Object)eggTemplate.create(TextureMapping.getBlockTexture((Block)((Block)AllTheMonsRegistrator.POKEMON_EGG_BLOCK.get())).withPath(p -> p + "_level_" + level), TextureMapping.cube((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("block/pokemon_egg_level_" + level))), this.modelOutput)))));
        }

        private void createApricornPlant(Block block, String prefix) {
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)RenderTypedModelTemplate.CROSS.create(ModelLocationUtils.getModelLocation((Block)block), TextureMapping.cross((Block)block), this.modelOutput))));
        }

        private void createApricornBlock(Block block) {
            ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)block).withPath(p -> "block/" + p);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)BlockStateProperties.AGE_3).generate(age -> {
                ResourceLocation modelLocation = age < 3 ? ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("block/apricorn_stage_" + age)) : RenderTypedModelTemplate.APRICORN.create(location, new TextureMapping().put(RenderTypedModelTemplate.APRICORN_SLOT, TextureMapping.getBlockTexture((Block)block)), this.modelOutput);
                return Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation);
            })).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.SOUTH, Variant.variant()).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180))));
        }

        private void createPikapowerBlock(Block block) {
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.property((Property)BlockStateProperties.DOUBLE_BLOCK_HALF).generate(part -> Variant.variant().with(VariantProperties.MODEL, (Object)ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)("block/pika_power_base_" + part.getSerializedName()))))));
        }

        private void createBaseModels() {
            RenderTypedModelTemplate.APRICORNS[0].create(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"block/apricorn_stage_0"), new TextureMapping(), this.modelOutput);
            RenderTypedModelTemplate.APRICORNS[1].create(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"block/apricorn_stage_1"), new TextureMapping(), this.modelOutput);
            RenderTypedModelTemplate.APRICORNS[2].create(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)"block/apricorn_stage_2"), new TextureMapping(), this.modelOutput);
        }

        static MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation modelLocation) {
            return MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)modelLocation));
        }
    }
}

