/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.datagen;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.allthemods.allthemons.registry.AllTheMonsRegistrator;
import net.allthemods.allthemons.registry.PokemonDataComponents;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootDataProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final List<LootTableProvider.SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public LootDataProvider(PackOutput output, List<LootTableProvider.SubProviderEntry> providers, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "loot_table");
        this.subProviders = providers;
        this.registries = registries;
    }

    public String getName() {
        return "All The Mons Block Loot Table datagen";
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        return this.registries.thenCompose(provider -> this.run(pOutput, (HolderLookup.Provider)provider));
    }

    private CompletableFuture<?> run(CachedOutput pOutput, HolderLookup.Provider pProvider) {
        HashMap map = Maps.newHashMap();
        this.subProviders.forEach(providerEntry -> ((LootTableSubProvider)providerEntry.provider().apply(pProvider)).generate((resourceKey, builder) -> {
            builder.setRandomSequence(resourceKey.location());
            if (map.put(resourceKey.location(), builder.setParamSet(providerEntry.paramSet()).build()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(resourceKey.location()));
            }
        }));
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)pProvider, (Codec)LootTable.DIRECT_CODEC, (Object)((LootTable)entry.getValue()), (Path)this.pathProvider.json((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static class LootProvider
    extends BlockLootSubProvider {
        private static final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();
        private List<Block> knownBlocks = new ArrayList<Block>();

        public LootProvider(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            for (String name : new String[]{"allthemodium", "vibranium", "unobtainium"}) {
                this.dropOther((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(name + "_apricorn_sapling"))), (ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(name + "_apricorn_seed"))));
                Block apricorn = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(name + "_apricorn")));
                Item apricornItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(name + "_apricorn")));
                Item apricornSeed = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"allthemons", (String)(name + "_apricorn_seed")));
                LootItemBlockStatePropertyCondition.Builder lootitemcondition$builder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)apricorn).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockStateProperties.AGE_3, 3));
                this.add(apricorn, this.createCropDrops(apricorn, apricornItem, apricornSeed, (LootItemCondition.Builder)lootitemcondition$builder));
            }
            this.add((Block)AllTheMonsRegistrator.PIKA_POWER_BASE_BLOCK.get(), this.createSinglePropConditionTable((Block)AllTheMonsRegistrator.PIKA_POWER_BASE_BLOCK.get(), (Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable<T> & StringRepresentable)DoubleBlockHalf.LOWER));
            this.add((Block)AllTheMonsRegistrator.POKEMON_EGG_BLOCK.get(), this.createEggDrop((Block)AllTheMonsRegistrator.POKEMON_EGG_BLOCK.get()));
        }

        protected void add(Block block, LootTable.Builder builder) {
            super.add(block, builder);
            this.knownBlocks.add(block);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }

        protected void add(Block block, Function<Block, LootTable.Builder> builderFunction) {
            this.add(block, builderFunction.apply(block));
        }

        public void dropInherited(Block original, Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, LootProvider::genInheritedBlockDrop);
            this.add(block, func.apply(original));
        }

        protected <T extends Comparable<T> & StringRepresentable> LootTable.Builder createSinglePropConditionTable(Block block, Property<T> property, T value) {
            return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(property, value))))));
        }

        protected static LootTable.Builder genInheritedBlockDrop(Block block) {
            LootPoolEntryContainer.Builder builder = NestedLootTable.lootTableReference((ResourceKey)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)BuiltInRegistries.BLOCK.getKey((Object)block).withPath(p -> "blocks/" + p))).when(ExplosionCondition.survivesExplosion());
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)5.0f)).add(builder));
        }

        protected LootTable.Builder createCropDrops(Block cropBlock, Item grownCropItem, Item seedsItem, LootItemCondition.Builder dropGrownCropCondition) {
            return (LootTable.Builder)this.applyExplosionDecay((ItemLike)cropBlock, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add(LootItem.lootTableItem((ItemLike)grownCropItem).when(dropGrownCropCondition))).withPool(LootPool.lootPool().when(dropGrownCropCondition).add(LootItem.lootTableItem((ItemLike)seedsItem).when(LootItemRandomChanceCondition.randomChance((float)0.1f)))));
        }

        protected LootTable.Builder createEggDrop(Block eggBlock) {
            return (LootTable.Builder)this.applyExplosionDecay((ItemLike)eggBlock, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)eggBlock).apply(LootProvider.eggComponents()))));
        }

        private static LootItemFunction.Builder eggComponents() {
            return CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(PokemonDataComponents.SPECIES.get()).include(PokemonDataComponents.NATURE.get()).include(PokemonDataComponents.EGG_MOVES.get()).include(PokemonDataComponents.IVS.get()).include(PokemonDataComponents.EGG_LEVEL.get()).include(PokemonDataComponents.EGG_TIME.get());
        }
    }
}

