/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.allthemods.allthemons.datagen.BiomeTagProvider;
import net.allthemods.allthemons.datagen.BlockTagProvider;
import net.allthemods.allthemons.datagen.EntityTypeTagProvider;
import net.allthemods.allthemons.datagen.ItemTagProvider;
import net.allthemods.allthemons.datagen.LanguageProvider;
import net.allthemods.allthemons.datagen.LootDataProvider;
import net.allthemods.allthemons.datagen.ModelProvider;
import net.allthemods.allthemons.datagen.POITagProvider;
import net.allthemods.allthemons.datagen.RecipeProvider;
import net.allthemods.allthemons.datagen.recipe.create.CuttingRecipeProvider;
import net.allthemods.allthemons.datagen.recipe.create.DeployingRecipeProvider;
import net.allthemods.allthemons.datagen.recipe.create.FillingRecipeProvider;
import net.allthemods.allthemons.datagen.recipe.create.PressingRecipeProvider;
import net.allthemods.allthemons.datagen.recipe.create.SequencedAssemblyRecipeProvider;
import net.allthemods.allthemons.datagen.recipe.create.WashingRecipeProvider;
import net.allthemods.allthemons.datagen.recipe.mekanism.MechanismRecipeProvider;
import net.allthemods.allthemons.datagen.recipe.oritech.OritechRecipeProvider;
import net.allthemods.allthemons.datagen.recipe.pneumaticraft.PNCRecipeProvider;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;

@EventBusSubscriber(modid="allthemons")
public class AllTheMonsDataProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture<HolderLookup.Provider> provider = CompletableFuture.supplyAsync(() -> AllTheMonsDataProvider.getProvider().full());
        ExistingFileHelper helper = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)new LanguageProvider(output));
        gen.addProvider(event.includeClient(), (DataProvider)new ModelProvider(output));
        gen.addProvider(event.includeServer(), (DataProvider)new LootDataProvider(output, List.of(new LootTableProvider.SubProviderEntry(LootDataProvider.LootProvider::new, LootContextParamSets.BLOCK)), provider));
        gen.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new OritechRecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new MechanismRecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new PNCRecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new SequencedAssemblyRecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new CuttingRecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new WashingRecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new DeployingRecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new PressingRecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new FillingRecipeProvider(output, provider));
        BlockTagProvider blockTags = new BlockTagProvider(output, provider, helper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(output, provider, blockTags.contentsGetter(), helper));
        gen.addProvider(event.includeServer(), (DataProvider)new EntityTypeTagProvider(output, provider, helper));
        gen.addProvider(event.includeServer(), (DataProvider)new POITagProvider(output, provider, helper));
        gen.addProvider(event.includeServer(), (DataProvider)new BiomeTagProvider(output, provider, helper));
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.BIOME, $ -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }
}

