/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.compat.jei;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import cy.jdkdigital.productivemetalworks.integration.jei.ingredient.EntityRenderer;
import java.util.Map;
import java.util.WeakHashMap;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.allthemods.allthemons.common.recipe.FossilRecipe;
import net.allthemods.allthemons.compat.jei.JeiPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FossilRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<FossilRecipe>> {
    static Map<String, Entity> MONS_CACHE = new WeakHashMap<String, Entity>();

    public FossilRecipeCategory(IGuiHelper guiHelper) {
        super(JeiPlugin.FOSSIL, (Component)Component.translatable((String)"jei.allthemons.fossil"), guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CobblemonItems.DOME_FOSSIL)), 165, 66);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<FossilRecipe> recipe, IFocusGroup iFocusGroup) {
        int i = 0;
        for (ItemStack item : ((FossilRecipe)recipe.value()).getInput().getItems()) {
            builder.addSlot(RecipeIngredientRole.INPUT, ++i * 24, 24).addItemStack(item.copy());
        }
    }

    public void draw(RecipeHolder<FossilRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        EntityRenderer.render((GuiGraphics)guiGraphics, (int)126, (int)24, (Entity)FossilRecipeCategory.createPokemon((Level)Minecraft.getInstance().level, ((FossilRecipe)recipe.value()).getOutput().getPath()), (Minecraft)Minecraft.getInstance());
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<FossilRecipe> recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Entity entity;
        if (mouseX >= 106.0 && mouseX < 160.0 && mouseY >= 8.0 && mouseY < 56.0 && (entity = FossilRecipeCategory.createPokemon((Level)Minecraft.getInstance().level, ((FossilRecipe)recipe.value()).getOutput().getPath())) != null) {
            tooltip.add((FormattedText)entity.getDisplayName());
        }
        super.getTooltip(tooltip, recipe, recipeSlotsView, mouseX, mouseY);
    }

    private static Entity createPokemon(Level level, String species) {
        if (!MONS_CACHE.containsKey(species)) {
            PokemonProperties properties = PokemonProperties.Companion.parse("species=\"" + species + "\"");
            MONS_CACHE.put(species, (Entity)properties.createEntity(level));
        }
        return MONS_CACHE.get(species);
    }
}

