/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.common.item;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.HatchEggEvent;
import com.cobblemon.mod.common.api.events.pokemon.ShinyChanceCalculationEvent;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import net.allthemods.allthemons.registry.PokemonDataComponents;
import net.allthemods.allthemons.util.MonUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PokemonEggItem
extends ItemNameBlockItem {
    public PokemonEggItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (stack.has(PokemonDataComponents.EGG_TIME) && stack.has(PokemonDataComponents.SPECIES) && stack.get(PokemonDataComponents.SPECIES) != null) {
                    int time = (Integer)stack.getOrDefault(PokemonDataComponents.EGG_TIME, (Object)2);
                    stack.set(PokemonDataComponents.EGG_TIME, (Object)(--time));
                    if (time <= 0) {
                        PokemonProperties properties = MonUtil.getProperties((ResourceLocation)stack.get(PokemonDataComponents.SPECIES), 5, (String)stack.get(PokemonDataComponents.NATURE), (List)stack.get(PokemonDataComponents.EGG_MOVES), (Map)stack.get(PokemonDataComponents.IVS));
                        CobblemonEvents.HATCH_EGG_PRE.post((Object[])new HatchEggEvent.Pre[]{new HatchEggEvent.Pre(properties, serverPlayer)}, pre -> {
                            PokemonEntity spawnedPokemon = MonUtil.spawnPokemon(serverLevel, entity.blockPosition(), properties);
                            if (spawnedPokemon != null && !stack.isEmpty()) {
                                CobblemonEvents.SHINY_CHANCE_CALCULATION.post((Object[])new ShinyChanceCalculationEvent[]{new ShinyChanceCalculationEvent(Cobblemon.config.getShinyRate() / (float)((Integer)stack.getOrDefault(PokemonDataComponents.SHINY_MODIFIER, (Object)1)).intValue(), spawnedPokemon.getPokemon())}, e -> {
                                    spawnedPokemon.getPokemon().setShiny(level.random.nextFloat() < 1.0f / e.calculate(serverPlayer));
                                    return Unit.INSTANCE;
                                });
                                CobblemonEvents.HATCH_EGG_POST.post((Object[])new HatchEggEvent.Post[]{new HatchEggEvent.Post(serverPlayer, spawnedPokemon.getPokemon())}, post -> null);
                                stack.shrink(1);
                                entity.playSound(SoundEvents.SNIFFER_EGG_CRACK, 1.0f, (serverLevel.random.nextFloat() - serverLevel.random.nextFloat()) * 0.2f + 1.0f);
                            }
                            return Unit.INSTANCE;
                        });
                    }
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.is(newStack.getItem());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (stack.get(PokemonDataComponents.SPECIES) != null) {
            Species species = PokemonSpecies.getByIdentifier((ResourceLocation)((ResourceLocation)stack.get(PokemonDataComponents.SPECIES)));
            if (species != null) {
                ChatFormatting color = switch (species.getPrimaryType().getName()) {
                    case "Grass" -> ChatFormatting.DARK_GREEN;
                    case "Bug" -> ChatFormatting.GREEN;
                    case "Water" -> ChatFormatting.DARK_BLUE;
                    case "Ice" -> ChatFormatting.BLUE;
                    case "Electric" -> ChatFormatting.YELLOW;
                    case "Fire" -> ChatFormatting.DARK_RED;
                    case "Rock", "Steel" -> ChatFormatting.GRAY;
                    case "Ground" -> ChatFormatting.DARK_GRAY;
                    case "Poison" -> ChatFormatting.DARK_PURPLE;
                    case "Psychic", "Fairy" -> ChatFormatting.LIGHT_PURPLE;
                    case "Dark" -> ChatFormatting.BLACK;
                    case "Dragon" -> ChatFormatting.DARK_AQUA;
                    case "Fighting" -> ChatFormatting.AQUA;
                    default -> ChatFormatting.WHITE;
                };
                tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".species"), (Object[])new Object[]{Component.literal((String)species.getName()).withStyle(color)}).withStyle(ChatFormatting.DARK_GRAY));
            }
            tooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".egg_time"), (Object[])new Object[]{Component.literal((String)((Integer)stack.getOrDefault(PokemonDataComponents.EGG_TIME, (Object)2) / 20 + "s")).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

