/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.common.item;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.ofekn.crafting_on_a_stick.api.IWheelItem;
import com.ofekn.crafting_on_a_stick.api.Ref;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class HealingStationOnAStickItem
extends Item
implements IWheelItem {
    public HealingStationOnAStickItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        return HealingStationOnAStickItem.useHeal(player, player.getItemInHand(usedHand));
    }

    public static InteractionResultHolder<ItemStack> useHeal(Player player, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (BattleRegistry.getBattleByParticipatingPlayer((ServerPlayer)serverPlayer) != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"cobblemon.healingmachine.inbattle").withStyle(ChatFormatting.RED), true);
                    return InteractionResultHolder.success((Object)stack);
                }
                PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer);
                if (party.size() == 0) {
                    player.displayClientMessage((Component)Component.translatable((String)"cobblemon.healingmachine.nopokemon").withStyle(ChatFormatting.RED), true);
                    return InteractionResultHolder.success((Object)stack);
                }
                float neededHealthPercent = party.getHealingRemainderPercent();
                if (neededHealthPercent == 0.0f) {
                    player.displayClientMessage((Component)Component.translatable((String)"cobblemon.healingmachine.alreadyhealed").withStyle(ChatFormatting.RED), true);
                    return InteractionResultHolder.success((Object)stack);
                }
                if (!Cobblemon.INSTANCE.getConfig().getInfiniteHealerCharge()) {
                    player.getCooldowns().addCooldown(stack.getItem(), (int)neededHealthPercent * 3000);
                }
                party.heal();
                player.displayClientMessage((Component)Component.translatable((String)"cobblemon.healingmachine.healed").withStyle(ChatFormatting.GREEN), true);
                serverLevel.playSound((Player)serverPlayer, serverPlayer.blockPosition(), CobblemonSounds.HEALING_MACHINE_ACTIVE, SoundSource.PLAYERS);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)player.level().isClientSide);
    }

    public void onWheelAction(Player player, Ref<ItemStack> ref) {
        HealingStationOnAStickItem.useHeal(player, (ItemStack)ref.get());
    }
}

