/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.common.block.entity;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.HatchEggEvent;
import com.cobblemon.mod.common.api.events.pokemon.ShinyChanceCalculationEvent;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.stat.CobblemonStatProvider;
import com.mojang.authlib.GameProfile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Unit;
import net.allthemods.allthemons.registry.AllTheMonsRegistrator;
import net.allthemods.allthemons.registry.PokemonDataComponents;
import net.allthemods.allthemons.util.MonUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.NotNull;

public class PokemonEggBlockEntity
extends BlockEntity {
    public static final UUID EGG_UUID = UUID.nameUUIDFromBytes("shellby".getBytes(StandardCharsets.UTF_8));
    public Species species;
    public int eggTime = -1;
    public Integer eggLevel = 1;
    public List<MoveTemplate> eggMoves;
    public Map<String, Integer> ivs;
    public String nature;
    public int shinyModifier = 1;
    private static Map<Stat, TagKey<Item>> statItems = new HashMap<Stat, TagKey<Item>>(){
        {
            this.put(Stats.SPEED, CobblemonItemTags.POWER_ANKLET);
            this.put(Stats.SPECIAL_DEFENCE, CobblemonItemTags.POWER_BAND);
            this.put(Stats.DEFENCE, CobblemonItemTags.POWER_BELT);
            this.put(Stats.ATTACK, CobblemonItemTags.POWER_BRACER);
            this.put(Stats.SPECIAL_ATTACK, CobblemonItemTags.POWER_LENS);
            this.put(Stats.HP, CobblemonItemTags.POWER_WEIGHT);
        }
    };

    public PokemonEggBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)AllTheMonsRegistrator.POKEMON_EGG_BLOCK_ENTITY.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PokemonEggBlockEntity eggBlockEntity) {
        if (eggBlockEntity.species != null && eggBlockEntity.eggTime-- <= 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            eggBlockEntity.eggTime = 6000;
            FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)new GameProfile(EGG_UUID, "atm_shellby"));
            PokemonProperties properties = MonUtil.getProperties(eggBlockEntity.species.getResourceIdentifier(), 5, eggBlockEntity.nature, eggBlockEntity.eggMoves, eggBlockEntity.ivs);
            CobblemonEvents.HATCH_EGG_PRE.post((Object[])new HatchEggEvent.Pre[]{new HatchEggEvent.Pre(properties, (ServerPlayer)fakePlayer)}, pre -> {
                PokemonEntity spawnedPokemon = MonUtil.spawnPokemon(serverLevel, pos.above(), properties);
                if (spawnedPokemon != null) {
                    CobblemonEvents.SHINY_CHANCE_CALCULATION.post((Object[])new ShinyChanceCalculationEvent[]{new ShinyChanceCalculationEvent(Cobblemon.config.getShinyRate() / (float)eggBlockEntity.shinyModifier, spawnedPokemon.getPokemon())}, e -> {
                        spawnedPokemon.getPokemon().setShiny(level.random.nextFloat() < 1.0f / e.calculate((ServerPlayer)fakePlayer));
                        return Unit.INSTANCE;
                    });
                    CobblemonEvents.HATCH_EGG_POST.post((Object[])new HatchEggEvent.Post[]{new HatchEggEvent.Post((ServerPlayer)fakePlayer, spawnedPokemon.getPokemon())}, post -> null);
                    level.destroyBlock(pos, false);
                    level.playSound(null, pos, SoundEvents.SNIFFER_EGG_CRACK, SoundSource.BLOCKS, 1.0f, (level.random.nextFloat() - level.random.nextFloat()) * 0.2f + 1.0f);
                }
                return Unit.INSTANCE;
            });
        }
    }

    public void setParents(Pokemon parent1, Pokemon parent2, int eggLevel) {
        if (this.level == null) {
            return;
        }
        RandomSource rand = this.level.getRandom();
        this.species = parent1.getSpecies();
        while (this.species.getPreEvolution() != null) {
            this.species = this.species.getPreEvolution().getSpecies();
        }
        ArrayList equippedMoves = new ArrayList();
        parent1.getMoveSet().forEach(move -> equippedMoves.add(move.getTemplate()));
        parent2.getMoveSet().forEach(move -> equippedMoves.add(move.getTemplate()));
        List<Object> equippedEggMoves = new ArrayList<MoveTemplate>();
        for (MoveTemplate eggMove : parent1.getSpecies().getMoves().getEggMoves()) {
            if (!equippedMoves.contains(eggMove)) continue;
            equippedEggMoves.add(eggMove);
        }
        for (MoveTemplate eggMove : parent2.getSpecies().getMoves().getEggMoves()) {
            if (!equippedMoves.contains(eggMove)) continue;
            equippedEggMoves.add(eggMove);
        }
        Collections.shuffle(equippedEggMoves);
        if (equippedEggMoves.size() > 4) {
            equippedEggMoves = equippedEggMoves.subList(3, equippedEggMoves.size() - 1);
        }
        this.eggMoves = equippedEggMoves;
        HashMap<String, Integer> eggIvs = new HashMap<String, Integer>();
        ItemStack parent1HeldItem = parent1.getHeldItem$common();
        ItemStack parent2HeldItem = parent2.getHeldItem$common();
        int inheritedStatCount = parent1HeldItem.is((Item)CobblemonItems.DESTINY_KNOT) || parent2HeldItem.is((Item)CobblemonItems.DESTINY_KNOT) ? 5 : 3;
        ArrayList keys = new ArrayList(Stats.Companion.getPERMANENT());
        Collections.shuffle(keys);
        for (Stat stat2 : keys) {
            if (eggIvs.size() >= inheritedStatCount) continue;
            eggIvs.put(stat2.getIdentifier().getPath(), this.getInheritedStat(rand, stat2, parent1HeldItem, parent2HeldItem, parent1.getIvs().get(stat2), parent2.getIvs().get(stat2)));
        }
        Stats.Companion.getPERMANENT().forEach(stat -> {
            if (!eggIvs.containsKey(stat.getIdentifier().getPath())) {
                eggIvs.put(stat.getIdentifier().getPath(), CobblemonStatProvider.INSTANCE.getStatForPokemon(parent1, stat));
            }
        });
        this.ivs = eggIvs;
        Nature natureClass = parent1HeldItem.is((Item)CobblemonItems.EVERSTONE) ? (parent2HeldItem.is((Item)CobblemonItems.EVERSTONE) && rand.nextBoolean() ? parent2.getNature() : parent1.getNature()) : (parent2HeldItem.is((Item)CobblemonItems.EVERSTONE) ? parent2.getNature() : Natures.INSTANCE.getRandomNature());
        this.nature = natureClass.getName().getPath();
        if (parent1.getOriginalTrainerName() != null) {
            this.shinyModifier = !parent1.getOriginalTrainerName().equals(parent2.getOriginalTrainerName()) ? 6 : 1;
        }
        this.eggLevel = eggLevel;
        if (this.level != null) {
            this.eggTime = this.level.random.nextInt(6000) + 6000 * this.eggLevel;
        }
    }

    private int getInheritedStat(RandomSource rand, Stat stat, ItemStack held1, ItemStack held2, int ivValue1, int ivValue2) {
        if (held1.is(statItems.get(stat))) {
            return held2.is(statItems.get(stat)) && rand.nextBoolean() ? ivValue2 : ivValue1;
        }
        if (held2.is(statItems.get(stat))) {
            return ivValue2;
        }
        return rand.nextBoolean() ? ivValue1 : ivValue2;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.species != null) {
            tag.putString("species", this.species.getResourceIdentifier().toString());
        }
        if (this.eggMoves != null) {
            ListTag eggMoveTag = new ListTag();
            for (MoveTemplate moveTemplate : this.eggMoves) {
                eggMoveTag.add((Object)StringTag.valueOf((String)moveTemplate.getName()));
            }
            tag.put("moves", (Tag)eggMoveTag);
        }
        if (this.ivs != null) {
            ListTag ivTag = new ListTag();
            this.ivs.forEach((stat, value) -> {
                CompoundTag statTag = new CompoundTag();
                statTag.putString("stat", stat);
                statTag.putInt("value", value.intValue());
                ivTag.add((Object)statTag);
            });
            tag.put("ivs", (Tag)ivTag);
        }
        if (this.nature != null) {
            tag.putString("nature", this.nature);
        }
        tag.putInt("eggTime", this.eggTime);
        tag.putInt("eggLevel", this.eggLevel.intValue());
        tag.putInt("shinyModifier", this.shinyModifier);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadPacketNBT(tag, registries);
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("species")) {
            this.species = PokemonSpecies.getByIdentifier((ResourceLocation)ResourceLocation.parse((String)tag.getString("species")));
        }
        if (tag.contains("moves")) {
            this.eggMoves = new ArrayList<MoveTemplate>();
            ListTag movesList = tag.getList("moves", 8);
            movesList.forEach(moveName -> this.eggMoves.add(Moves.getByNameOrDummy((String)moveName.getAsString())));
        }
        if (tag.contains("ivs")) {
            this.ivs = new HashMap<String, Integer>();
            ListTag ivList = tag.getList("ivs", 10);
            ivList.forEach(statTag -> this.ivs.put(((CompoundTag)statTag).getString("stat"), ((CompoundTag)statTag).getInt("value")));
        }
        this.eggTime = tag.contains("eggTime") ? tag.getInt("eggTime") : 0;
        this.eggLevel = tag.contains("eggLevel") ? tag.getInt("eggLevel") : 1;
        this.shinyModifier = tag.contains("shinyModifier") ? tag.getInt("shinyModifier") : 1;
        this.nature = tag.contains("nature") ? tag.getString("nature") : Natures.INSTANCE.getRandomNature().getName().getPath();
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        super.onDataPacket(net, pkt, provider);
        this.loadPacketNBT(pkt.getTag(), provider);
        if (this.level instanceof ClientLevel) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 0);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        Map ivs;
        List eggMoves;
        super.applyImplicitComponents(componentInput);
        ResourceLocation species = (ResourceLocation)componentInput.get(PokemonDataComponents.SPECIES);
        if (species != null) {
            this.species = PokemonSpecies.getByIdentifier((ResourceLocation)species);
        }
        if ((eggMoves = (List)componentInput.get(PokemonDataComponents.EGG_MOVES)) != null) {
            this.eggMoves = (List)componentInput.getOrDefault(PokemonDataComponents.EGG_MOVES, List.of());
        }
        if ((ivs = (Map)componentInput.get(PokemonDataComponents.IVS)) != null) {
            this.ivs = (Map)componentInput.getOrDefault(PokemonDataComponents.IVS, new HashMap());
        }
        this.nature = (String)componentInput.getOrDefault(PokemonDataComponents.NATURE, (Object)Natures.INSTANCE.getRandomNature().getName().getPath());
        this.eggTime = (Integer)componentInput.getOrDefault(PokemonDataComponents.EGG_TIME, (Object)0);
        this.eggLevel = (Integer)componentInput.getOrDefault(PokemonDataComponents.EGG_LEVEL, (Object)1);
        this.shinyModifier = (Integer)componentInput.getOrDefault(PokemonDataComponents.SHINY_MODIFIER, (Object)1);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (this.species != null) {
            components.set(PokemonDataComponents.SPECIES, (Object)this.species.getResourceIdentifier());
        }
        if (this.eggMoves != null) {
            components.set(PokemonDataComponents.EGG_MOVES, this.eggMoves);
        }
        if (this.ivs != null) {
            components.set(PokemonDataComponents.IVS, this.ivs);
        }
        components.set(PokemonDataComponents.NATURE, (Object)this.nature);
        components.set(PokemonDataComponents.EGG_TIME, (Object)this.eggTime);
        components.set(PokemonDataComponents.EGG_LEVEL, (Object)this.eggLevel);
        components.set(PokemonDataComponents.SHINY_MODIFIER, (Object)this.shinyModifier);
    }
}

