/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.common.block.entity;

import com.gitlab.srcmc.rctmod.world.blocks.entities.TrainerSpawnerBlockEntity;
import java.util.Set;
import net.allthemods.allthemons.registry.AllTheMonsRegistrator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BetterTrainerSpawnerBlockEntity
extends TrainerSpawnerBlockEntity {
    private String trainerId = "";
    private Integer maxDistance = 32;

    public BetterTrainerSpawnerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)AllTheMonsRegistrator.TRAINER_SPAWNER_BLOCK_ENTITY.get();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("trainer", this.trainerId);
        tag.putInt("maxDistance", this.maxDistance.intValue());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.trainerId = tag.getString("trainer");
        this.maxDistance = tag.getInt("maxDistance");
    }

    public Set<String> getTrainerIds() {
        return Set.of(this.trainerId);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, BetterTrainerSpawnerBlockEntity be) {
        TrainerSpawnerBlockEntity.serverTick((Level)level, (BlockPos)blockPos, (BlockState)blockState, (TrainerSpawnerBlockEntity)be);
        if (be.getOwner() != null && level.getGameTime() % 10L == 0L) {
            be.getOwner().setHomePos(null);
            if (!blockPos.closerThan((Vec3i)be.getOwner().blockPosition(), (double)be.maxDistance.intValue())) {
                be.getOwner().moveTo((double)blockPos.getX(), (double)(blockPos.getY() + 1), (double)blockPos.getZ());
            }
        }
    }
}

