/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.common.block;

import com.mojang.serialization.MapCodec;
import net.allthemods.allthemons.common.block.entity.PokemonEggBlockEntity;
import net.allthemods.allthemons.registry.AllTheMonsRegistrator;
import net.allthemods.allthemons.registry.PokemonDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class PokemonEggBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"egg_level", (int)1, (int)5);
    public static final MapCodec<PokemonEggBlock> CODEC = PokemonEggBlock.simpleCodec(PokemonEggBlock::new);
    VoxelShape SHAPE = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.empty(), (VoxelShape)Shapes.box((double)0.4375, (double)0.75, (double)0.4375, (double)0.5625, (double)0.8125, (double)0.5625), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.375, (double)0.6875, (double)0.375, (double)0.625, (double)0.75, (double)0.625), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.25, (double)0.0625, (double)0.25, (double)0.75, (double)0.5625, (double)0.75), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.1875, (double)0.1875, (double)0.1875, (double)0.8125, (double)0.4375, (double)0.8125), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.5, (double)0.9375, (double)0.5, (double)0.5, (double)0.9375, (double)0.5), (BooleanOp)BooleanOp.OR);

    public PokemonEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(1))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LEVEL, BlockStateProperties.WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        return (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is(Tags.Fluids.WATER)))).setValue((Property)LEVEL, (Comparable)((Integer)context.getItemInHand().getOrDefault(PokemonDataComponents.EGG_LEVEL, (Object)1)));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PokemonEggBlockEntity(pos, state);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = ((Item)AllTheMonsRegistrator.POKEMON_EGG_ITEM.get()).getDefaultInstance();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PokemonEggBlockEntity) {
            PokemonEggBlockEntity eggBlockEntity = (PokemonEggBlockEntity)blockEntity;
            if (eggBlockEntity.species != null) {
                stack.set(PokemonDataComponents.SPECIES, (Object)eggBlockEntity.species.getResourceIdentifier());
                stack.set(PokemonDataComponents.NATURE, (Object)eggBlockEntity.nature);
                stack.set(PokemonDataComponents.EGG_MOVES, eggBlockEntity.eggMoves);
                stack.set(PokemonDataComponents.IVS, eggBlockEntity.ivs);
                stack.set(PokemonDataComponents.EGG_TIME, (Object)eggBlockEntity.eggTime);
                stack.set(PokemonDataComponents.EGG_LEVEL, (Object)eggBlockEntity.eggLevel);
                stack.set(PokemonDataComponents.SHINY_MODIFIER, (Object)eggBlockEntity.shinyModifier);
            }
        }
        return stack;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : PokemonEggBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)AllTheMonsRegistrator.POKEMON_EGG_BLOCK_ENTITY.get()), PokemonEggBlockEntity::tick);
    }
}

