/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.common.block;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.pasture.PastureLink;
import com.cobblemon.mod.common.api.pasture.PastureLinkManager;
import com.cobblemon.mod.common.api.pasture.PasturePermissions;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.UUID;
import net.allthemods.allthemons.common.block.entity.PikaPowerBlockEntity;
import net.allthemods.allthemons.network.OpenPikaPowerPayload;
import net.allthemods.allthemons.registry.AllTheMonsRegistrator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;

public class PikaPowerBlock
extends RotatedPillarKineticBlock
implements IBE<PikaPowerBlockEntity> {
    private static final VoxelShape TOP = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.empty(), (VoxelShape)Shapes.box((double)0.4375, (double)0.25, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.OR);

    public PikaPowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.UPPER) ? TOP : Shapes.block();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.DOUBLE_BLOCK_HALF});
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (((DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            return level.getBlockState(pos.below()).is(state.getBlock());
        }
        return super.canSurvive(state, level, pos);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.LOWER) && !level.getBlockState(pos.above()).is(state.getBlock())) {
            return Blocks.AIR.defaultBlockState();
        }
        if (((DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.UPPER) && !level.getBlockState(pos.below()).is(state.getBlock())) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        return super.playerWillDestroy(level, pos, state, player);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.IGNORE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)Direction.Axis.Y);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        if (((DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            return false;
        }
        return face.getAxis() != state.getValue((Property)AXIS);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    public Class<PikaPowerBlockEntity> getBlockEntityClass() {
        return PikaPowerBlockEntity.class;
    }

    public BlockEntityType<? extends PikaPowerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllTheMonsRegistrator.PIKA_POWER_BASE_BLOCK_ENTITY.get();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockPos basePos;
        BlockEntity blockEntity;
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && !PlayerExtensionsKt.isInBattle((ServerPlayer)(serverPlayer = (ServerPlayer)player)) && (blockEntity = level.getBlockEntity(basePos = ((DoubleBlockHalf)state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.UPPER) ? pos.below() : pos)) instanceof PikaPowerBlockEntity) {
            PikaPowerBlockEntity pikaPowerBlockEntity = (PikaPowerBlockEntity)blockEntity;
            UUID pcId = Cobblemon.INSTANCE.getStorage().getPC(serverPlayer).getUuid();
            UUID linkId = UUID.randomUUID();
            PasturePermissions perms = new PasturePermissions(true, true, pikaPowerBlockEntity.getMaxTethered());
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenPikaPowerPayload(pcId, linkId, pikaPowerBlockEntity.getMaxTethered(), pikaPowerBlockEntity.tetheredPokemon.stream().map(tethering -> tethering.toDTO(serverPlayer)).toList(), perms), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PastureLinkManager.createLink((UUID)serverPlayer.getUUID(), (PastureLink)new PastureLink(linkId, pcId, ResourceLocation.tryParse((String)level.dimensionTypeRegistration().getRegisteredName()), basePos, perms));
            player.playSound(CobblemonSounds.PC_ON, 0.5f, 1.0f);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_OPEN, basePos);
        }
        return InteractionResult.SUCCESS;
    }
}

