/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.common.block;

import com.cobblemon.mod.common.api.tags.CobblemonBlockTags;
import com.cobblemon.mod.common.api.tags.CobblemonItemTags;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ATMApricornBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock {
    public static final MapCodec<ATMApricornBlock> CODEC = ATMApricornBlock.simpleCodec(ATMApricornBlock::new);
    private final VoxelShape NORTH_STAGE_0 = Shapes.box((double)0.40625, (double)0.5, (double)0.0, (double)0.59375, (double)0.6875, (double)0.1875);
    private final VoxelShape NORTH_CAP_STAGE_0 = Shapes.box((double)0.4375, (double)0.65625, (double)0.03125, (double)0.5625, (double)0.71875, (double)0.15625);
    private final VoxelShape NORTH_STAGE_1 = Shapes.box((double)0.375, (double)0.40625, (double)0.0, (double)0.625, (double)0.65625, (double)0.25);
    private final VoxelShape NORTH_CAP_STAGE_1 = Shapes.box((double)0.40625, (double)0.625, (double)0.03125, (double)0.59375, (double)0.6875, (double)0.21875);
    private final VoxelShape NORTH_STAGE_2 = Shapes.box((double)0.34375, (double)0.296875, (double)0.0, (double)0.65625, (double)0.609375, (double)0.3125);
    private final VoxelShape NORTH_CAP_STAGE_2 = Shapes.box((double)0.375, (double)0.59375, (double)0.03125, (double)0.625, (double)0.65625, (double)0.28125);
    private final VoxelShape NORTH_STAGE_3 = Shapes.box((double)0.3125, (double)0.1875, (double)0.0, (double)0.6875, (double)0.5625, (double)0.375);
    private final VoxelShape NORTH_CAP_STAGE_3 = Shapes.box((double)0.375, (double)0.5625, (double)0.0625, (double)0.625, (double)0.625, (double)0.3125);
    private final VoxelShape[] NORTH_AABB = new VoxelShape[]{Shapes.or((VoxelShape)this.NORTH_STAGE_0, (VoxelShape)this.NORTH_CAP_STAGE_0), Shapes.or((VoxelShape)this.NORTH_STAGE_1, (VoxelShape)this.NORTH_CAP_STAGE_1), Shapes.or((VoxelShape)this.NORTH_STAGE_2, (VoxelShape)this.NORTH_CAP_STAGE_2), Shapes.or((VoxelShape)this.NORTH_STAGE_3, (VoxelShape)this.NORTH_CAP_STAGE_3)};
    private final VoxelShape SOUTH_STAGE_0 = Shapes.box((double)0.40625, (double)0.5, (double)0.8125, (double)0.59375, (double)0.6875, (double)1.0);
    private final VoxelShape SOUTH_CAP_STAGE_0 = Shapes.box((double)0.4375, (double)0.65625, (double)0.84375, (double)0.5625, (double)0.71875, (double)0.96875);
    private final VoxelShape SOUTH_STAGE_1 = Shapes.box((double)0.375, (double)0.40625, (double)0.75, (double)0.625, (double)0.65625, (double)1.0);
    private final VoxelShape SOUTH_CAP_STAGE_1 = Shapes.box((double)0.40625, (double)0.625, (double)0.78125, (double)0.59375, (double)0.6875, (double)0.96875);
    private final VoxelShape SOUTH_STAGE_2 = Shapes.box((double)0.34375, (double)0.296875, (double)0.6875, (double)0.65625, (double)0.609375, (double)1.0);
    private final VoxelShape SOUTH_CAP_STAGE_2 = Shapes.box((double)0.375, (double)0.59375, (double)0.71875, (double)0.625, (double)0.65625, (double)0.96875);
    private final VoxelShape SOUTH_STAGE_3 = Shapes.box((double)0.3125, (double)0.1875, (double)0.625, (double)0.6875, (double)0.5625, (double)1.0);
    private final VoxelShape SOUTH_CAP_STAGE_3 = Shapes.box((double)0.375, (double)0.5625, (double)0.6875, (double)0.625, (double)0.625, (double)0.9375);
    private final VoxelShape[] SOUTH_AABB = new VoxelShape[]{Shapes.or((VoxelShape)this.SOUTH_STAGE_0, (VoxelShape)this.SOUTH_CAP_STAGE_0), Shapes.or((VoxelShape)this.SOUTH_STAGE_1, (VoxelShape)this.SOUTH_CAP_STAGE_1), Shapes.or((VoxelShape)this.SOUTH_STAGE_2, (VoxelShape)this.SOUTH_CAP_STAGE_2), Shapes.or((VoxelShape)this.SOUTH_STAGE_3, (VoxelShape)this.SOUTH_CAP_STAGE_3)};
    private final VoxelShape EAST_STAGE_0 = Shapes.box((double)0.8125, (double)0.5, (double)0.40625, (double)1.0, (double)0.6875, (double)0.59375);
    private final VoxelShape EAST_CAP_STAGE_0 = Shapes.box((double)0.84375, (double)0.65625, (double)0.4375, (double)0.96875, (double)0.71875, (double)0.5625);
    private final VoxelShape EAST_STAGE_1 = Shapes.box((double)0.75, (double)0.40625, (double)0.375, (double)1.0, (double)0.65625, (double)0.625);
    private final VoxelShape EAST_CAP_STAGE_1 = Shapes.box((double)0.78125, (double)0.625, (double)0.40625, (double)0.96875, (double)0.6875, (double)0.59375);
    private final VoxelShape EAST_STAGE_2 = Shapes.box((double)0.6875, (double)0.296875, (double)0.34375, (double)1.0, (double)0.609375, (double)0.65625);
    private final VoxelShape EAST_CAP_STAGE_2 = Shapes.box((double)0.71875, (double)0.59375, (double)0.375, (double)0.96875, (double)0.65625, (double)0.625);
    private final VoxelShape EAST_STAGE_3 = Shapes.box((double)0.625, (double)0.1875, (double)0.3125, (double)1.0, (double)0.5625, (double)0.6875);
    private final VoxelShape EAST_CAP_STAGE_3 = Shapes.box((double)0.6875, (double)0.5625, (double)0.375, (double)0.9375, (double)0.625, (double)0.625);
    private final VoxelShape[] EAST_AABB = new VoxelShape[]{Shapes.or((VoxelShape)this.EAST_STAGE_0, (VoxelShape)this.EAST_CAP_STAGE_0), Shapes.or((VoxelShape)this.EAST_STAGE_1, (VoxelShape)this.EAST_CAP_STAGE_1), Shapes.or((VoxelShape)this.EAST_STAGE_2, (VoxelShape)this.EAST_CAP_STAGE_2), Shapes.or((VoxelShape)this.EAST_STAGE_3, (VoxelShape)this.EAST_CAP_STAGE_3)};
    private final VoxelShape WEST_STAGE_0 = Shapes.box((double)0.0, (double)0.5, (double)0.40625, (double)0.1875, (double)0.6875, (double)0.59375);
    private final VoxelShape WEST_CAP_STAGE_0 = Shapes.box((double)0.03125, (double)0.65625, (double)0.4375, (double)0.15625, (double)0.71875, (double)0.5625);
    private final VoxelShape WEST_STAGE_1 = Shapes.box((double)0.0, (double)0.40625, (double)0.375, (double)0.25, (double)0.65625, (double)0.625);
    private final VoxelShape WEST_CAP_STAGE_1 = Shapes.box((double)0.03125, (double)0.625, (double)0.40625, (double)0.21875, (double)0.6875, (double)0.59375);
    private final VoxelShape WEST_STAGE_2 = Shapes.box((double)0.0, (double)0.296875, (double)0.34375, (double)0.3125, (double)0.609375, (double)0.65625);
    private final VoxelShape WEST_CAP_STAGE_2 = Shapes.box((double)0.03125, (double)0.59375, (double)0.375, (double)0.28125, (double)0.65625, (double)0.625);
    private final VoxelShape WEST_STAGE_3 = Shapes.box((double)0.0, (double)0.1875, (double)0.3125, (double)0.375, (double)0.5625, (double)0.6875);
    private final VoxelShape WEST_CAP_STAGE_3 = Shapes.box((double)0.0625, (double)0.5625, (double)0.375, (double)0.3125, (double)0.625, (double)0.625);
    private final VoxelShape[] WEST_AABB = new VoxelShape[]{Shapes.or((VoxelShape)this.WEST_STAGE_0, (VoxelShape)this.WEST_CAP_STAGE_0), Shapes.or((VoxelShape)this.WEST_STAGE_1, (VoxelShape)this.WEST_CAP_STAGE_1), Shapes.or((VoxelShape)this.WEST_STAGE_2, (VoxelShape)this.WEST_CAP_STAGE_2), Shapes.or((VoxelShape)this.WEST_STAGE_3, (VoxelShape)this.WEST_CAP_STAGE_3)};

    public ATMApricornBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BlockStateProperties.AGE_3});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = this.defaultBlockState();
        Level worldView = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        for (Direction direction : context.getNearestLookingDirections()) {
            if (!direction.getAxis().isHorizontal() || !(blockState = (BlockState)blockState.setValue((Property)FACING, (Comparable)direction)).canSurvive((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Integer age = (Integer)state.getValue((Property)BlockStateProperties.AGE_3);
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> this.SOUTH_AABB[age];
            case Direction.WEST -> this.WEST_AABB[age];
            case Direction.EAST -> this.EAST_AABB[age];
            default -> this.NORTH_AABB[age];
        };
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        ItemEntity item;
        EntityCollisionContext eContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (eContext = (EntityCollisionContext)context).getEntity()) instanceof ItemEntity && (item = (ItemEntity)entity).getItem().is(CobblemonItemTags.APRICORNS)) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, level, pos, context);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (this.isRandomlyTicking(state)) {
            return super.useWithoutItem(state, level, pos, player, hitResult);
        }
        this.doHarvest(level, state, pos, player);
        return InteractionResult.SUCCESS;
    }

    protected void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (this.isRandomlyTicking(state)) {
            super.attack(state, level, pos, player);
        }
        this.doHarvest(level, state, pos, player);
    }

    private void doHarvest(Level level, BlockState state, BlockPos pos, Player player) {
        BlockState resetState = this.harvest(level, state, pos);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)resetState));
        if (!level.isClientSide) {
            level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.7f, 1.4f);
        }
    }

    private BlockState harvest(Level level, BlockState state, BlockPos pos) {
        Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos);
        BlockState resetState = (BlockState)state.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(0));
        level.setBlock(pos, resetState, 2);
        return resetState;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)BlockStateProperties.AGE_3) < 3;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return this.isRandomlyTicking(blockState);
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf((Integer)blockState.getValue((Property)BlockStateProperties.AGE_3) + 1)), 2);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int currentAge;
        if (level.random.nextInt(5) == 0 && (currentAge = ((Integer)state.getValue((Property)BlockStateProperties.AGE_3)).intValue()) < 3) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(currentAge + 1)), 2);
        }
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos.relative((Direction)state.getValue((Property)FACING)));
        return blockState.is(CobblemonBlockTags.APRICORN_LEAVES);
    }
}

