/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.commands;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerSpawner;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.allthemods.allthemons.AllTheMons;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class AdditionalTrainerCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"allthemons").requires(b -> b.hasPermission(1))).then(((LiteralArgumentBuilder)Commands.literal((String)"spawn_named_trainer").requires(b -> b.hasPermission(2))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(p -> AdditionalTrainerCommands.spawnNamedTrainer((CommandContext<CommandSourceStack>)p, StringArgumentType.getString((CommandContext)p, (String)"name"))))));
    }

    private static int spawnNamedTrainer(CommandContext<CommandSourceStack> context, String name) {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            try {
                AdditionalTrainerCommands.attemptSpawnFor(player, name);
            }
            catch (Exception e) {
                AllTheMons.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    public static boolean attemptSpawnFor(Player player, String name) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        AllTheMons.LOGGER.debug("spawn_named_trainer command invoked with name " + name);
        TrainerSpawner trainerSpawner = RCTMod.getInstance().getTrainerSpawner();
        Method canSpawnFor = trainerSpawner.getClass().getDeclaredMethod("canSpawnFor", Player.class, Boolean.TYPE, Double.TYPE, Double.TYPE);
        canSpawnFor.setAccessible(true);
        Method isMarkedAt = trainerSpawner.getClass().getDeclaredMethod("isMarkedAt", Level.class, BlockPos.class);
        isMarkedAt.setAccessible(true);
        Method spawnFor = trainerSpawner.getClass().getDeclaredMethod("spawnFor", Player.class, String.class, BlockPos.class);
        spawnFor.setAccessible(true);
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        if (((Boolean)canSpawnFor.invoke((Object)trainerSpawner, player, false, cfg.globalSpawnChance(), cfg.globalSpawnChanceMinimum())).booleanValue()) {
            for (int i = 0; i < 8; ++i) {
                BlockPos pos = trainerSpawner.nextPos(player);
                if (pos == null) continue;
                SpawnCandidate spawnCandidate = AdditionalTrainerCommands.nextSpawnCandidate(trainerSpawner, player, pos);
                if (spawnCandidate != null) {
                    String[] nameParts;
                    TrainerMob trainer = (TrainerMob)spawnFor.invoke((Object)trainerSpawner, player, spawnCandidate.id, pos);
                    TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(trainer);
                    Object prefix = "";
                    if (trainer.getCustomName() != null && (nameParts = trainer.getCustomName().getString().split(" ")).length > 1) {
                        prefix = nameParts[0] + " ";
                        String[] secondaryNames = new String[]{"Trainer", "Girl", "Keeper", "Belt", "Emboar", "Ferrothorn", "Catcher", "Couple", "Kin", "Ball", "Team", "Tamer", "Four", "Coach", "Maniac", "Teacher", "Thug", "Freaks", "Leader", "Fan", "Kid", "Breeder", "Ranger", "Boy", "Admin", "Society", "Grunt", "Nerd", "Rocket", "Granbull", "Defense", "Couple"};
                        if (Arrays.asList(secondaryNames).contains(nameParts[1])) {
                            prefix = (String)prefix + nameParts[1] + " ";
                        }
                    }
                    trainer.setCustomName((Component)Component.literal((String)((String)prefix + name)));
                    trainer.moveTo(player.position());
                }
                return true;
            }
        }
        return false;
    }

    private static SpawnCandidate nextSpawnCandidate(TrainerSpawner trainerSpawner, Player player, BlockPos pos) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ArrayList<SpawnCandidate> candidates;
        block2: {
            Set tags;
            Level level;
            Method computeWeight;
            Method isUnique;
            block3: {
                boolean dimensionWhitelisted;
                isUnique = trainerSpawner.getClass().getDeclaredMethod("isUnique", String.class, Level.class, BlockPos.class);
                isUnique.setAccessible(true);
                computeWeight = trainerSpawner.getClass().getDeclaredMethod("computeWeight", Player.class, String.class, TrainerMobData.class);
                computeWeight.setAccessible(true);
                candidates = new ArrayList<SpawnCandidate>();
                level = player.level();
                tags = level.getBiome(pos).tags().map(t -> t.location().getNamespace() + ":" + t.location().getPath()).collect(Collectors.toSet());
                level.getBiome(pos).tags().map(t -> t.location().getPath()).forEach(tags::add);
                IServerConfig config = RCTMod.getInstance().getServerConfig();
                boolean dimensionBlacklisted = config.dimensionBlacklist().contains(level.dimension().location().toString());
                boolean bl = dimensionWhitelisted = config.dimensionWhitelist().isEmpty() || config.dimensionWhitelist().contains(level.dimension().location().toString());
                if (dimensionBlacklisted || !dimensionWhitelisted) break block2;
                if (!config.biomeTagBlacklist().stream().noneMatch(tags::contains)) break block2;
                if (config.biomeTagWhitelist().isEmpty()) break block3;
                if (!config.biomeTagWhitelist().stream().anyMatch(tags::contains)) break block2;
            }
            RCTMod.getInstance().getTrainerManager().getAllData(new String[]{PlayerState.get((Player)player).getCurrentSeries()}).filter(e -> {
                try {
                    if ((Boolean)isUnique.invoke((Object)trainerSpawner, ((TrainerMobData)e.getValue()).getTrainerTeam().getIdentity(), level, pos) == false) return false;
                    if (!((TrainerMobData)e.getValue()).getBiomeTagBlacklist().stream().noneMatch(tags::contains)) return false;
                    if (((TrainerMobData)e.getValue()).getBiomeTagWhitelist().isEmpty()) return true;
                    if (!((TrainerMobData)e.getValue()).getBiomeTagWhitelist().stream().anyMatch(tags::contains)) return false;
                    return true;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return false;
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }).forEach(e -> {
                double weight = 0.0;
                try {
                    weight = (Double)computeWeight.invoke((Object)trainerSpawner, player, e.getKey(), e.getValue());
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
                if (weight > 0.0) {
                    candidates.add(new SpawnCandidate((String)e.getKey(), weight));
                }
            });
        }
        return !candidates.isEmpty() ? AdditionalTrainerCommands.selectRandom(player.getRandom(), candidates) : null;
    }

    private static SpawnCandidate selectRandom(RandomSource rng, List<SpawnCandidate> candidates) {
        int i;
        double totalWeight = candidates.stream().map(c -> c.weight).reduce(0.0, Double::sum);
        double r = rng.nextDouble() * totalWeight;
        for (i = 0; i < candidates.size() - 1 && !((r -= candidates.get((int)i).weight) <= 0.0); ++i) {
        }
        return candidates.get(i);
    }

    private static class SpawnCandidate {
        public final String id;
        public final double weight;

        public SpawnCandidate(String id, double weight) {
            this.id = id;
            this.weight = weight;
        }
    }
}

