/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.client.visual.block;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.AbstractInstance;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import net.allthemods.allthemons.common.block.entity.PikaPowerBlockEntity;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class PikaPowerVisual
extends KineticBlockEntityVisual<PikaPowerBlockEntity> {
    protected final EnumMap<Direction, RotatingInstance> keys = new EnumMap(Direction.class);

    public PikaPowerVisual(VisualizationContext context, PikaPowerBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        if (((DoubleBlockHalf)blockEntity.getBlockState().getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            return;
        }
        Direction.Axis boxAxis = (Direction.Axis)this.blockState.getValue((Property)BlockStateProperties.AXIS);
        Instancer instancer = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF));
        for (Direction direction : Iterate.directions) {
            Direction.Axis axis = direction.getAxis();
            if (boxAxis == axis) continue;
            RotatingInstance instance = (RotatingInstance)instancer.createInstance();
            instance.setup((KineticBlockEntity)blockEntity, axis, this.getSpeed(direction)).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, direction).setChanged();
            this.keys.put(direction, instance);
        }
    }

    private float getSpeed(Direction direction) {
        return ((PikaPowerBlockEntity)this.blockEntity).getSpeed() * (float)(direction.equals((Object)Direction.NORTH) || direction.equals((Object)Direction.WEST) ? -1 : 1);
    }

    public void update(float pt) {
        for (Map.Entry<Direction, RotatingInstance> key : this.keys.entrySet()) {
            Direction direction = key.getKey();
            Direction.Axis axis = direction.getAxis();
            key.getValue().setup((KineticBlockEntity)this.blockEntity, axis, this.getSpeed(direction)).setChanged();
        }
    }

    public void updateLight(float partialTick) {
        this.relight((FlatLit[])this.keys.values().toArray(FlatLit[]::new));
    }

    protected void _delete() {
        this.keys.values().forEach(AbstractInstance::delete);
        this.keys.clear();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        this.keys.values().forEach(consumer);
    }
}

