/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.allthemons.client.gui;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.cobblemon.mod.common.client.gui.CobblemonRenderable;
import com.cobblemon.mod.common.client.gui.PokemonGuiUtilsKt;
import com.cobblemon.mod.common.client.gui.pasture.PastureSlotIconButton;
import com.cobblemon.mod.common.client.gui.pasture.PastureSlotIconConflictButton;
import com.cobblemon.mod.common.client.gui.summary.widgets.PartySlotWidget;
import com.cobblemon.mod.common.client.render.RenderHelperKt;
import com.cobblemon.mod.common.client.render.models.blockbench.FloatingState;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.pokemon.PokemonBehaviourFlag;
import com.cobblemon.mod.common.net.messages.client.pasture.OpenPasturePacket;
import com.cobblemon.mod.common.net.messages.server.pasture.SetPastureConflictPacket;
import com.cobblemon.mod.common.net.messages.server.pasture.UnpasturePokemonPacket;
import com.cobblemon.mod.common.util.math.QuaternionUtilsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import kotlin.Unit;
import net.allthemods.allthemons.client.gui.PikaPowerPCGUIConfiguration;
import net.allthemods.allthemons.client.gui.PikaPowerWidget;
import net.allthemods.allthemons.util.KotlinHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PikaPowerScrollList
extends ObjectSelectionList<PikaPowerSlot>
implements CobblemonRenderable {
    static Integer WIDTH = 70;
    static Integer HEIGHT = 120;
    static Integer SLOT_WIDTH = 62;
    static Integer SLOT_HEIGHT = 29;
    static Integer SLOT_SPACING = 3;
    static Float SCALE = Float.valueOf(0.5f);
    private final Integer listX;
    private final Integer listY;
    private final PikaPowerWidget parent;
    private static final ResourceLocation scrollOverlayResource = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"textures/gui/pasture/pasture_scroll_overlay.png");
    private static final ResourceLocation slotResource = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"textures/gui/pasture/pasture_slot.png");
    private static final ResourceLocation slotOwnerResource = ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"textures/gui/pasture/pasture_slot_owner.png");
    private boolean scrolling = false;

    public PikaPowerScrollList(Integer listX, Integer listY, PikaPowerWidget parent) {
        super(Minecraft.getInstance(), WIDTH.intValue(), HEIGHT.intValue(), 0, SLOT_HEIGHT + SLOT_SPACING);
        this.listX = listX;
        this.listY = listY;
        this.parent = parent;
        this.setX(listX);
        this.setY(listY);
        this.correctSize();
        parent.configuration.pasturedPokemon.subscribeIncludingCurrent(Priority.NORMAL, newValue -> {
            List currentChildren = this.children();
            List<PikaPowerSlot> newEntries = this.children().stream().filter(pk -> currentChildren.stream().noneMatch(child -> child.pokemon.getPokemonId() == pk.pokemon.getPokemonId())).toList();
            List<PikaPowerSlot> removedEntries = currentChildren.stream().filter(child -> this.children().stream().noneMatch(pk -> pk.pokemon.getPokemonId() == child.pokemon.getPokemonId())).toList();
            removedEntries.forEach(x$0 -> this.removeEntry((AbstractSelectionList.Entry)x$0));
            newEntries.forEach(slot -> this.addEntry((AbstractSelectionList.Entry)new PikaPowerSlot(slot.pokemon, parent)));
            return Unit.INSTANCE;
        });
    }

    public int getRowWidth() {
        return SLOT_WIDTH;
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width - 3;
    }

    protected void renderSelection(GuiGraphics guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.correctSize();
        guiGraphics.pose().pushPose();
        guiGraphics.enableScissor(this.getX(), this.getY() + 4, this.getX() + this.width, this.getY() - 1 + this.height);
        guiGraphics.pose().popPose();
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.disableScissor();
        this.height = 131;
        this.width = WIDTH;
        GuiUtilsKt.blitk((PoseStack)guiGraphics.pose(), (ResourceLocation)scrollOverlayResource, (Number)this.getX(), (Number)(this.getY() - 13), (Number)131, (Number)this.width);
        PikaPowerPCGUIConfiguration config = this.parent.configuration;
        KotlinHelper.drawScaledText(guiGraphics, Component.literal((String)(this.children().stream().filter(PikaPowerSlot::isOwned).count() + "/" + config.permissions.getMaxPokemon())).withStyle(ChatFormatting.BOLD), (float)this.getX() + (float)WIDTH.intValue() / 2.0f, this.getY() + 7);
    }

    private void correctSize() {
        this.setRectangle(WIDTH, HEIGHT, this.listX, this.listY - 4);
    }

    private void updateScrollingState(Double mouseX, Double mouseY) {
        this.scrolling = mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 3) && mouseY >= (double)this.listY.intValue() && mouseY < (double)this.getBottom();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY);
        if (this.scrolling) {
            this.setFocused((GuiEventListener)this.getEntryAtPosition(mouseX, mouseY));
            this.setDragging(true);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.scrollbarVisible() && mouseX >= (double)this.getScrollbarPosition()) {
            if (mouseY < (double)this.listY.intValue()) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)this.getBottom()) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                this.setScrollAmount(this.getScrollAmount() + dragY);
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean isHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + WIDTH) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + HEIGHT);
    }

    public static class PikaPowerSlot
    extends ObjectSelectionList.Entry<PikaPowerSlot> {
        public final OpenPasturePacket.PasturePokemonDataDTO pokemon;
        public final PikaPowerWidget parent;
        private final Minecraft client = Minecraft.getInstance();
        private final FloatingState state = new FloatingState();
        private final PastureSlotIconConflictButton conflictButton;
        private final PastureSlotIconButton moveButton;

        public PikaPowerSlot(OpenPasturePacket.PasturePokemonDataDTO pokemon, PikaPowerWidget parent) {
            this.pokemon = pokemon;
            this.parent = parent;
            this.conflictButton = new PastureSlotIconConflictButton(0, 0, button -> {
                parent.storageWidget.getPcGui().playSound(CobblemonSounds.PC_CLICK);
                boolean currentlyEnabled = pokemon.getBehaviourFlags().contains(PokemonBehaviourFlag.PASTURE_CONFLICT);
                new SetPastureConflictPacket(pokemon.getPokemonId(), !currentlyEnabled).sendToServer();
            });
            this.conflictButton.setEnabled(pokemon.getBehaviourFlags().contains(PokemonBehaviourFlag.PASTURE_CONFLICT));
            this.moveButton = new PastureSlotIconButton(0, 0, button -> {
                parent.storageWidget.getPcGui().playSound(CobblemonSounds.PC_CLICK);
                new UnpasturePokemonPacket(parent.configuration.pastureId, pokemon.getPokemonId()).sendToServer();
            });
        }

        public boolean isOwned() {
            return this.client.player != null && this.client.player.getUUID().equals(this.pokemon.getPlayerId());
        }

        public boolean canUnpasture() {
            return this.isOwned();
        }

        public Boolean canDefend() {
            return false;
        }

        public Component getNarration() {
            return this.pokemon.getDisplayName();
        }

        public void render(GuiGraphics context, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
            int x = rowLeft - 4;
            int y = rowTop + 2;
            PoseStack poseStack = context.pose();
            GuiUtilsKt.blitk((PoseStack)poseStack, (ResourceLocation)(this.isOwned() ? slotOwnerResource : slotResource), (Number)x, (Number)y, (Number)SLOT_HEIGHT, (Number)rowWidth, (Number)(isHovered ? SLOT_HEIGHT : 0), (Number)(SLOT_HEIGHT * 2));
            poseStack.pushPose();
            poseStack.translate((double)(x + 11) + 12.5, (double)y - 1.0, 0.0);
            poseStack.scale(2.5f, 2.5f, 1.0f);
            this.state.setCurrentAspects(this.pokemon.getAspects());
            PokemonGuiUtilsKt.drawProfilePokemon((ResourceLocation)this.pokemon.getSpecies(), (PoseStack)poseStack, (Quaternionf)QuaternionUtilsKt.fromEulerXYZDegrees((Quaternionf)new Quaternionf(), (Vector3f)new Vector3f(13.0f, 35.0f, 0.0f)), (PoseType)PoseType.PROFILE, (PosableState)this.state, (float)partialTicks, (float)4.5f, (boolean)true, (boolean)false, (boolean)false, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            poseStack.popPose();
            if (!this.pokemon.getHeldItem().isEmpty()) {
                RenderHelperKt.renderScaledGuiItemIcon((ItemStack)this.pokemon.getHeldItem(), (double)((double)x + 23.5), (double)((double)y + 13.0), (double)0.5, (float)100.0f, (PoseStack)poseStack);
            }
            KotlinHelper.drawScaledTextJustifiedRight(context, Component.translatable((String)"cobblemon.ui.lv.number", (Object[])new Object[]{this.pokemon.getLevel()}), x + 59, y + 17, SCALE.floatValue());
            MutableComponent nameText = isHovered && this.pokemon.getOwnerName() != null ? Component.literal((String)this.pokemon.getOwnerName()).withStyle(ChatFormatting.ITALIC) : this.pokemon.getDisplayName().copy();
            KotlinHelper.drawScaledText(context, nameText, x + 11, y + 24, SCALE.floatValue());
            if (this.pokemon.getAspects().contains("male") || this.pokemon.getAspects().contains("female")) {
                ResourceLocation genderIcon = this.pokemon.getAspects().contains("male") ? PartySlotWidget.Companion.getGenderIconMale() : PartySlotWidget.Companion.getGenderIconFemale();
                GuiUtilsKt.blitk((PoseStack)poseStack, (ResourceLocation)genderIcon, (Number)Float.valueOf(((float)x + 56.5f) / SCALE.floatValue()), (Number)Float.valueOf(((float)y + 24.0f) / SCALE.floatValue()), (Number)7, (Number)5, (Number)SCALE);
            }
            if (this.canUnpasture()) {
                if (Boolean.TRUE.equals(this.canDefend())) {
                    this.conflictButton.setPos(x + 44, y + 3);
                    this.conflictButton.render(context, mouseX, mouseY, partialTicks);
                }
                this.moveButton.setPos(x + 2, y + 11);
                this.moveButton.render(context, mouseX, mouseY, partialTicks);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.canUnpasture()) {
                return false;
            }
            if (Boolean.TRUE.equals(this.canDefend()) && this.conflictButton.isHovered(mouseX, mouseY)) {
                this.conflictButton.onPress();
                return true;
            }
            if (this.moveButton.isHovered(mouseX, mouseY)) {
                this.moveButton.onPress();
                return true;
            }
            return false;
        }
    }
}

