/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.mixin.patternprovider;

import appeng.api.config.Actionable;
import appeng.api.config.LockCraftingMode;
import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.networking.IGrid;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.IConfigManager;
import appeng.helpers.patternprovider.PatternProviderLogic;
import appeng.helpers.patternprovider.PatternProviderLogicHost;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.util.ConfigManager;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lu.kolja.expandedae.definition.ExpItems;
import lu.kolja.expandedae.definition.ExpSettings;
import lu.kolja.expandedae.enums.ADDONS;
import lu.kolja.expandedae.enums.BlockingMode;
import lu.kolja.expandedae.helper.pattern.IPatternProviderLogic;
import lu.kolja.expandedae.helper.pattern.PatternProviderTarget;
import lu.kolja.expandedae.helper.pattern.PatternProviderTargetCache;
import lu.kolja.expandedae.mixin.accessor.AccessorCraftingCpuLogic;
import lu.kolja.expandedae.mixin.accessor.AccessorExecutingCraftingJob;
import lu.kolja.expandedae.mixin.compat.advancedae.AAEAccessorAdvCraftingCPULogic;
import lu.kolja.expandedae.mixin.compat.advancedae.AAEAccessorExecutingCraftingJob;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPU;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PatternProviderLogic.class}, remap=true)
public abstract class MixinPatternProviderLogic
implements IUpgradeableObject,
IPatternProviderLogic {
    @Unique
    private static final boolean AAE_LOADED = ADDONS.ADV.isLoaded();
    @Unique
    private PatternProviderTargetCache[] expandedae$targetCaches;
    @Shadow
    @Final
    private IActionSource actionSource;
    @Unique
    private IUpgradeInventory expandedae$upgrades = UpgradeInventories.empty();
    @Final
    @Shadow
    private PatternProviderLogicHost host;
    @Final
    @Shadow
    private IManagedGridNode mainNode;
    @Shadow
    @Final
    private IConfigManager configManager;
    @Shadow
    @Final
    private Set<AEKey> patternInputs;
    @Shadow
    private int roundRobinIndex;
    @Shadow
    @Final
    private List<GenericStack> sendList;
    @Shadow
    @Final
    private List<IPatternDetails> patterns;
    @Shadow
    private Direction sendDirection;

    @Shadow
    public abstract LockCraftingMode getCraftingLockedReason();

    @Shadow
    protected abstract Set<Direction> getActiveSides();

    @Shadow
    protected abstract void onPushPatternSuccess(IPatternDetails var1);

    @Shadow
    protected abstract <T> void rearrangeRoundRobin(List<T> var1);

    @Shadow
    public abstract boolean isBlocking();

    @Shadow
    protected abstract boolean sendStacksOut();

    @Shadow
    protected abstract void addToSendList(AEKey var1, long var2);

    @Shadow
    @Nullable
    public abstract IGrid getGrid();

    @Unique
    private void eae_$onUpgradesChanged() {
        this.host.saveChanges();
    }

    public IUpgradeInventory getUpgrades() {
        return this.expandedae$upgrades;
    }

    @Inject(method={"<init>(Lappeng/api/networking/IManagedGridNode;Lappeng/helpers/patternprovider/PatternProviderLogicHost;I)V"}, at={@At(value="TAIL")})
    private void eae_$initUpgrade(IManagedGridNode mainNode, PatternProviderLogicHost host, int patternInventorySize, CallbackInfo ci) {
        this.expandedae$upgrades = UpgradeInventories.forMachine((ItemLike)host.getTerminalIcon().getItem(), (int)1, this::eae_$onUpgradesChanged);
        this.expandedae$targetCaches = new PatternProviderTargetCache[6];
    }

    @Inject(method={"writeToNBT"}, at={@At(value="TAIL")})
    private void eae_$saveUpgrade(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        this.expandedae$upgrades.writeToNBT(tag, "upgrades", registries);
    }

    @Inject(method={"readFromNBT"}, at={@At(value="TAIL")})
    private void eae_$loadUpgrade(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        this.expandedae$upgrades.readFromNBT(tag, "upgrades", registries);
    }

    @Inject(method={"addDrops"}, at={@At(value="TAIL")})
    private void eae_$dropUpgrade(List<ItemStack> drops, CallbackInfo ci) {
        for (ItemStack is : this.expandedae$upgrades) {
            if (is.isEmpty()) continue;
            drops.add(is);
        }
    }

    @Inject(method={"clearContent"}, at={@At(value="TAIL")})
    private void eae_$clearUpgrade(CallbackInfo ci) {
        this.expandedae$upgrades.clear();
    }

    @Inject(method={"<init>(Lappeng/api/networking/IManagedGridNode;Lappeng/helpers/patternprovider/PatternProviderLogicHost;I)V"}, at={@At(value="TAIL")}, remap=false)
    private void PatternProviderLogic(IManagedGridNode mainNode, PatternProviderLogicHost host, int patternInventorySize, CallbackInfo ci) {
        ((ConfigManager)this.configManager).registerSetting(ExpSettings.BLOCKING_MODE, (Enum)BlockingMode.DEFAULT);
    }

    @Override
    public BlockingMode expandedae$getBlockingMode() {
        return (BlockingMode)this.configManager.getSetting(ExpSettings.BLOCKING_MODE);
    }

    @Overwrite
    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (this.sendList.isEmpty() && this.mainNode.isActive() && this.patterns.contains(patternDetails)) {
            BlockEntity be = this.host.getBlockEntity();
            Level level = be.getLevel();
            if (this.getCraftingLockedReason() == LockCraftingMode.NONE) {
                record PushTarget(Direction direction, PatternProviderTarget target) {
                }
                ArrayList<PushTarget> possibleTargets = new ArrayList<PushTarget>();
                for (Direction direction : this.getActiveSides()) {
                    BlockPos adjPos = be.getBlockPos().relative(direction);
                    BlockEntity adjBe = level.getBlockEntity(adjPos);
                    Direction adjBeSide = direction.getOpposite();
                    ICraftingMachine craftingMachine = ICraftingMachine.of((Level)level, (BlockPos)adjPos, (Direction)adjBeSide);
                    if (craftingMachine != null && craftingMachine.acceptsPlans()) {
                        if (!craftingMachine.pushPattern(patternDetails, inputHolder, adjBeSide)) continue;
                        this.onPushPatternSuccess(patternDetails);
                        return true;
                    }
                    PatternProviderTarget adapter = this.expandedae$findAdapter(direction);
                    if (adapter == null) continue;
                    possibleTargets.add(new PushTarget(direction, adapter));
                }
                if (patternDetails.supportsPushInputsToExternalInventory()) {
                    this.rearrangeRoundRobin(possibleTargets);
                    for (PushTarget target : possibleTargets) {
                        Direction direction = target.direction();
                        PatternProviderTarget adapter = target.target();
                        switch (this.expandedae$getBlockingMode()) {
                            case ALL: {
                                if (this.isBlocking() && !adapter.getStorage().getAvailableStacks().isEmpty() || !this.expandedae$adapterAcceptsAll(adapter, inputHolder)) break;
                                patternDetails.pushInputsToExternalInventory(inputHolder, (what, amount) -> {
                                    long inserted = adapter.insert(what, amount, Actionable.MODULATE);
                                    if (inserted < amount) {
                                        this.addToSendList(what, amount - inserted);
                                    }
                                });
                                this.onPushPatternSuccess(patternDetails);
                                this.sendDirection = direction;
                                this.sendStacksOut();
                                ++this.roundRobinIndex;
                                return true;
                            }
                            case SMART: {
                                if (this.isBlocking() && !adapter.getStorage().getAvailableStacks().isEmpty() && !adapter.onlyHasPatternInput(this.patternInputs) || !this.expandedae$adapterAcceptsAll(adapter, inputHolder)) break;
                                patternDetails.pushInputsToExternalInventory(inputHolder, (what, amount) -> {
                                    long inserted = adapter.insert(what, amount, Actionable.MODULATE);
                                    if (inserted < amount) {
                                        this.addToSendList(what, amount - inserted);
                                    }
                                });
                                this.onPushPatternSuccess(patternDetails);
                                this.sendDirection = direction;
                                this.sendStacksOut();
                                ++this.roundRobinIndex;
                                return true;
                            }
                            case DEFAULT: {
                                if (this.isBlocking() && adapter.containsPatternInput(this.patternInputs) || !this.expandedae$adapterAcceptsAll(adapter, inputHolder)) break;
                                patternDetails.pushInputsToExternalInventory(inputHolder, (what, amount) -> {
                                    long inserted = adapter.insert(what, amount, Actionable.MODULATE);
                                    if (inserted < amount) {
                                        this.addToSendList(what, amount - inserted);
                                    }
                                });
                                this.onPushPatternSuccess(patternDetails);
                                this.sendDirection = direction;
                                this.sendStacksOut();
                                ++this.roundRobinIndex;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    @Unique
    @Nullable
    private PatternProviderTarget expandedae$findAdapter(Direction side) {
        if (this.expandedae$targetCaches[side.get3DDataValue()] == null) {
            BlockEntity thisBe = this.host.getBlockEntity();
            this.expandedae$targetCaches[side.get3DDataValue()] = new PatternProviderTargetCache((ServerLevel)thisBe.getLevel(), thisBe.getBlockPos().relative(side), side.getOpposite(), this.actionSource);
        }
        return this.expandedae$targetCaches[side.get3DDataValue()].find();
    }

    @Unique
    private boolean expandedae$adapterAcceptsAll(PatternProviderTarget target, KeyCounter[] inputHolder) {
        int var4 = inputHolder.length;
        for (KeyCounter counter : inputHolder) {
            for (Object2LongMap.Entry input : counter) {
                long inserted = target.insert((AEKey)input.getKey(), input.getLongValue(), Actionable.SIMULATE);
                if (inserted != 0L) continue;
                return false;
            }
        }
        return true;
    }

    @Inject(method={"pushPattern"}, at={@At(value="HEAD")})
    private void expandedae$onPushPatternSuccess(IPatternDetails patternDetails, KeyCounter[] inputHolder, CallbackInfoReturnable<Boolean> cir) {
        this.expandedae$tryAutoCompleteCraft(patternDetails);
    }

    @Unique
    private void expandedae$tryAutoCompleteCraft(IPatternDetails details) {
        if (!this.getUpgrades().isInstalled(ExpItems.AUTO_COMPLETE_CARD)) {
            return;
        }
        ImmutableSet cpus = this.getGrid().getCraftingService().getCpus();
        for (ICraftingCPU cpu : cpus) {
            Object task;
            if (!cpu.isBusy()) continue;
            if (cpu instanceof CraftingCPUCluster) {
                CraftingCPUCluster cluster = (CraftingCPUCluster)cpu;
                task = ((AccessorExecutingCraftingJob)((AccessorCraftingCpuLogic)cluster.craftingLogic).getJob()).getTasks().get(details);
                if (task == null || task.getValue() > 1L) continue;
                cluster.cancelJob();
                return;
            }
            if (!AAE_LOADED || !(cpu instanceof AdvCraftingCPU)) continue;
            AdvCraftingCPU advCpu = (AdvCraftingCPU)cpu;
            task = ((AAEAccessorExecutingCraftingJob)((AAEAccessorAdvCraftingCPULogic)advCpu.craftingLogic).getJob()).getTasks().get(details);
            if (task == null || task.getValue() > 1L) continue;
            advCpu.cancelJob();
            return;
        }
    }
}

