/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.block.entity;

import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.util.AEColor;
import appeng.blockentity.storage.DriveBlockEntity;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ColorableDriveBlockEntity
extends DriveBlockEntity
implements IColorableBlockEntity {
    @NotNull
    private AEColor color = AEColor.TRANSPARENT;

    public ColorableDriveBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    public boolean recolourBlock(Direction side, AEColor colour, Player who) {
        if (colour == this.color) {
            return false;
        }
        this.color = colour;
        this.saveChanges();
        this.markForUpdate();
        this.getMainNode().setGridColor(this.color);
        return true;
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        this.color = data.contains("color") ? AEColor.valueOf((String)data.getString("color")) : AEColor.TRANSPARENT;
        this.getMainNode().setGridColor(this.color);
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        data.putString("color", this.color.name());
    }

    @NotNull
    @Generated
    public AEColor getColor() {
        return this.color;
    }
}

