/*
 * Decompiled with CFR 0.152.
 */
package lu.kolja.expandedae.block;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.util.InteractionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class ExpBlockBaseScreen<T extends AEBaseBlockEntity>
extends AEBaseEntityBlock<T> {
    public ExpBlockBaseScreen(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ExpBlockBaseScreen() {
        super(ExpBlockBaseScreen.metalProps());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        AEBaseBlockEntity be = this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            if (!level.isClientSide()) {
                this.openScreen(be, player);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemInteractionResult parent = super.useItemOn(heldItem, state, level, pos, player, hand, hit);
        if (parent.result() != InteractionResult.PASS) {
            return parent;
        }
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        AEBaseBlockEntity be = this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            if (!level.isClientSide()) {
                this.openScreen(be, player);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public abstract void openScreen(T var1, Player var2);

    @Nullable
    private InteractionResult check(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return null;
    }
}

