/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.coolant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.extremereactors.api.internal.AbstractNamedValue;
import it.zerono.mods.zerocore.lib.data.ModCodecs;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class Vapor
extends AbstractNamedValue {
    public static final Vapor EMPTY = new Vapor("empty", Colour.WHITE, 0.0f, "gui.zerocore.base.generic.empty");
    public static final ModCodecs<Vapor, ByteBuf> CODECS = new ModCodecs(RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(AbstractNamedValue::getName), (App)Colour.CODECS.field("colour", Vapor::getColour), (App)Codec.FLOAT.fieldOf("density").forGetter(Vapor::getFluidEnergyDensity), (App)Codec.STRING.fieldOf("translation").forGetter(AbstractNamedValue::getTranslationKey)).apply((Applicative)instance, Vapor::new)), StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, AbstractNamedValue::getName, (StreamCodec)Colour.CODECS.streamCodec(), Vapor::getColour, (StreamCodec)ByteBufCodecs.FLOAT, Vapor::getFluidEnergyDensity, (StreamCodec)ByteBufCodecs.STRING_UTF8, AbstractNamedValue::getTranslationKey, Vapor::new));
    private final float _fluidEnergyDensity;
    private final Colour _colour;

    Vapor(String name, Colour colour, float fluidEnergyDensity, String translationKey) {
        super(name, translationKey);
        this._fluidEnergyDensity = Math.max(0.0f, fluidEnergyDensity);
        this._colour = colour;
    }

    public float getFluidEnergyDensity() {
        return this._fluidEnergyDensity;
    }

    public Vapor copy() {
        return new Vapor(this.getName(), this.getColour(), this.getFluidEnergyDensity(), this.getTranslationKey());
    }

    public Colour getColour() {
        return this._colour;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Vapor && super.equals(obj) && this.getFluidEnergyDensity() == ((Vapor)obj).getFluidEnergyDensity();
    }
}

