/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.brandonscore.utils.SimplexNoise;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.ChaosCrystal;
import com.brandon3055.draconicevolution.blocks.DraconiumOre;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.init.DEContent;
import com.mojang.serialization.Codec;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class ChaosIslandFeature
extends Feature<NoneFeatureConfiguration> {
    public static final int CLEAR_RAD = 768;
    public static final int TRANS_DIST = 128;

    public ChaosIslandFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public static boolean overrideBiome(ChunkPos chunkPos, ChunkPos closestSpawn) {
        BlockPos closest;
        BlockPos pos = chunkPos.getMiddleBlockPosition(0);
        double distSqr = pos.distSqr((Vec3i)(closest = closestSpawn.getMiddleBlockPosition(0)));
        return distSqr < 589824.0;
    }

    public static void overrideHeightValue(ChunkPos chunkPos, ChunkPos closestSpawn, float initialHeight, Consumer<Float> override) {
        BlockPos closest;
        BlockPos pos = chunkPos.getMiddleBlockPosition(0);
        double distSqr = pos.distSqr((Vec3i)(closest = closestSpawn.getMiddleBlockPosition(0)));
        if (distSqr < 589824.0) {
            override.accept(Float.valueOf(-100.0f));
        } else if (distSqr < 802816.0) {
            double dist = MathHelper.sqrt((double)distSqr) - 768.0f;
            override.accept(Float.valueOf((float)MathHelper.map((double)dist, (double)0.0, (double)128.0, (double)-100.0, (double)initialHeight)));
        }
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos origin = context.origin();
        ChunkPos chunkPos = new ChunkPos(origin);
        ChunkPos closestSpawn = ChaosIslandFeature.getClosestSpawn(chunkPos);
        if (!DEConfig.chaosIslandEnabled) {
            return false;
        }
        if (closestSpawn.x == 0 && closestSpawn.z == 0) {
            return false;
        }
        WorldGenLevel level = context.level();
        RandomSource rand = context.random();
        BlockPos islandOrigin = closestSpawn.getBlockAt(0, DEConfig.chaosIslandYPosition, 0);
        if (islandOrigin.distSqr((Vec3i)origin) > (double)(DEConfig.chaosIslandSize * 5 * (DEConfig.chaosIslandSize * 5))) {
            return false;
        }
        boolean chunkModified = false;
        if (!DEConfig.chaosIslandVoidMode) {
            chunkModified = this.genIslandChunk(level, origin, islandOrigin, rand);
            chunkModified |= this.genCoreChunk(level, origin, islandOrigin, rand);
            chunkModified |= this.genRingChunk(level, origin, islandOrigin, rand);
        }
        if (ChaosIslandFeature.inChunk(origin, islandOrigin)) {
            level.setBlock(islandOrigin, ((ChaosCrystal)((Object)DEContent.CHAOS_CRYSTAL.get())).defaultBlockState(), 3);
            BlockEntity blockEntity = level.getBlockEntity(islandOrigin);
            if (blockEntity instanceof TileChaosCrystal) {
                TileChaosCrystal tile = (TileChaosCrystal)blockEntity;
                tile.onValidPlacement();
            }
            WorldEntityHandler.addWorldEntity((Level)level.getLevel(), (WorldEntity)new GuardianFightManager(islandOrigin));
            chunkModified = true;
        }
        return chunkModified;
    }

    public boolean genIslandChunk(WorldGenLevel level, BlockPos chunkOrigin, BlockPos islandOrigin, RandomSource rand) {
        boolean chunkModified = false;
        int minY = DEConfig.chaosIslandYPosition - 40;
        int maxY = DEConfig.chaosIslandYPosition + 40;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)chunkOrigin.offset(0, minY - chunkOrigin.getY(), 0), (BlockPos)chunkOrigin.offset(16, maxY - chunkOrigin.getY(), 16))) {
            double density;
            double plateauFalloff;
            int x = pos.getX() - islandOrigin.getX();
            int y = pos.getY() - islandOrigin.getY();
            int z = pos.getZ() - islandOrigin.getZ();
            double dist = Math.sqrt(pos.distSqr((Vec3i)islandOrigin));
            double xd = (double)x / (double)DEConfig.chaosIslandSize;
            double yd = 0.5 + (double)y / 32.0;
            double zd = (double)z / (double)DEConfig.chaosIslandSize;
            double centerFalloff = 1.0 / ((dist *= 80.0 / (double)DEConfig.chaosIslandSize) * 0.05);
            if (centerFalloff < 0.0) {
                centerFalloff = 0.0;
            }
            if ((plateauFalloff = yd < 0.4 ? yd * 2.5 : (yd <= 0.6 ? 1.0 : (yd > 0.6 && yd < 1.0 ? 1.0 - (yd - 0.6) * 2.5 : 0.0))) == 0.0 || centerFalloff == 0.0) continue;
            double heightMapFalloff = 0.0;
            for (int octave = 1; octave < 5; ++octave) {
                heightMapFalloff += (SimplexNoise.noise((double)(xd * (double)octave + (double)islandOrigin.getX()), (double)(zd * (double)octave + (double)islandOrigin.getZ())) + 1.0) * 0.5 * 0.01 * ((double)octave * 10.0 * 1.0 - dist * 0.001);
            }
            if (heightMapFalloff <= 0.0) {
                heightMapFalloff = 0.0;
            }
            if ((heightMapFalloff += (0.5 - Math.abs(yd - 0.5)) * 0.15) == 0.0 || !((density = centerFalloff * plateauFalloff * heightMapFalloff) > 0.1) || !level.isEmptyBlock(pos) || level.getBlockState(pos).getBlock() == Blocks.CAVE_AIR) continue;
            level.setBlock(pos, dist > 60.0 || dist > (double)rand.nextInt(60) ? Blocks.END_STONE.defaultBlockState() : Blocks.OBSIDIAN.defaultBlockState(), 3);
            chunkModified = true;
        }
        return chunkModified;
    }

    public boolean genCoreChunk(WorldGenLevel level, BlockPos chunkOrigin, BlockPos islandOrigin, RandomSource rand) {
        boolean chunkModified = false;
        int coreHeight = 10;
        int coreWidth = 20;
        int originX = islandOrigin.getX();
        int originZ = islandOrigin.getZ();
        for (int y = DEConfig.chaosIslandYPosition - coreHeight; y <= DEConfig.chaosIslandYPosition + coreHeight; ++y) {
            int yDist = Math.abs(y - DEConfig.chaosIslandYPosition);
            int inRadius = yDist - 3;
            double yp = (double)(coreHeight - yDist) / (double)coreHeight;
            int outRadius = (int)(yp * (double)coreWidth);
            outRadius -= outRadius * outRadius / 100;
            BlockPos sliceMin = new BlockPos(originX - outRadius, y, originZ - outRadius);
            BlockPos sliceMax = new BlockPos(originX + outRadius, y, originZ + outRadius);
            BlockPos slicePos = new BlockPos(originX, y, originZ);
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)sliceMin, (BlockPos)sliceMax)) {
                if (!ChaosIslandFeature.inChunk(chunkOrigin, pos)) continue;
                double distSq = pos.distSqr((Vec3i)islandOrigin);
                double distXZSq = pos.distSqr((Vec3i)slicePos);
                this.genCoreSlice(level, distSq, distXZSq, pos, inRadius, coreWidth, true, rand);
                this.genCoreSlice(level, distSq, distXZSq, pos, outRadius, coreWidth, false, rand);
            }
        }
        return chunkModified;
    }

    public boolean genCoreSlice(WorldGenLevel level, double distSq, double distXZSq, BlockPos pos, int ringRadius, int coreRadious, boolean fillIn, RandomSource rand) {
        Block b;
        int yOffset = Math.abs(DEConfig.chaosIslandYPosition - pos.getY());
        double oRad = (double)coreRadious - (double)(yOffset * yOffset) / 10.0;
        if (distSq > (oRad - 3.0) * (oRad - 3.0) && rand.nextDouble() * 3.0 < distSq - (oRad - 3.0) * (oRad - 3.0)) {
            return false;
        }
        if (fillIn && Math.sqrt(distXZSq) <= (double)ringRadius) {
            if (Math.sqrt(distSq) < 9.0) {
                level.setBlock(pos, ((BlockBCore)DEContent.INFUSED_OBSIDIAN.get()).defaultBlockState(), 3);
            } else {
                level.setBlock(pos, Blocks.OBSIDIAN.defaultBlockState(), 3);
            }
            return true;
        }
        if (!fillIn && distXZSq >= (double)((ringRadius - 1) * (ringRadius - 1))) {
            level.setBlock(pos, Blocks.OBSIDIAN.defaultBlockState(), 3);
            return true;
        }
        if (!fillIn && distXZSq <= (double)((ringRadius - 1) * (ringRadius - 1)) && ((b = level.getBlockState(pos).getBlock()) == Blocks.AIR || b == Blocks.END_STONE || b == Blocks.OBSIDIAN)) {
            level.setBlock(pos, Blocks.CAVE_AIR.defaultBlockState(), 3);
            return true;
        }
        return false;
    }

    public boolean genRingChunk(WorldGenLevel level, BlockPos chunkOrigin, BlockPos islandOrigin, RandomSource rand) {
        boolean chunkModified = false;
        int outerRadius = DEConfig.chaosIslandSize * 4;
        int rings = 4;
        int width = 20;
        int spacing = 20;
        for (int x = chunkOrigin.getX(); x < chunkOrigin.getX() + 16; ++x) {
            for (int z = chunkOrigin.getZ(); z < chunkOrigin.getZ() + 16; ++z) {
                int distSq = (int)Utils.getDistanceSq((double)x, (double)z, (double)islandOrigin.getX(), (double)islandOrigin.getZ());
                for (int i = 0; i < rings; ++i) {
                    int max = outerRadius - (width + spacing) * i;
                    int min = outerRadius - width - (width + spacing) * i;
                    if (distSq >= max * max || distSq < min * min) continue;
                    int y = 10 + (int)((double)(islandOrigin.getX() - x) * 0.1) + (rand.nextInt(10) - 5);
                    BlockPos setPos = new BlockPos(x, y + DEConfig.chaosIslandYPosition, z);
                    if (0.1f > rand.nextFloat()) {
                        level.setBlock(setPos, Blocks.END_STONE.defaultBlockState(), 3);
                        chunkModified = true;
                    }
                    if (!(0.001f > rand.nextFloat())) continue;
                    level.setBlock(setPos, ((DraconiumOre)((Object)DEContent.END_DRACONIUM_ORE.get())).defaultBlockState(), 3);
                    chunkModified = true;
                }
            }
        }
        return chunkModified;
    }

    public static ChunkPos getClosestSpawn(ChunkPos pos) {
        return new ChunkPos(MathUtils.getNearestMultiple((int)(pos.x * 16), (int)DEConfig.chaosIslandSeparation) / 16, MathUtils.getNearestMultiple((int)(pos.z * 16), (int)DEConfig.chaosIslandSeparation) / 16);
    }

    private static boolean inChunk(BlockPos ref, BlockPos test) {
        int x = ref.getX() - ref.getX() % 16;
        int z = ref.getZ() - ref.getZ() % 16;
        return test.getX() >= x && test.getZ() >= z && test.getX() <= x + 15 && test.getZ() <= z + 15;
    }

    public static void generateObelisk(ServerLevel world, BlockPos genPos, RandomSource rand) {
        for (int i = 0; i < 20; i += 3) {
            LightningBolt entity = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            entity.setPos((double)(genPos.getX() - 2 + rand.nextInt(5)), (double)(genPos.getY() - rand.nextInt(20)), (double)(genPos.getZ() - 2 + rand.nextInt(5)));
            world.addFreshEntity((Entity)entity);
        }
        if (DEConfig.chaosIslandVoidMode) {
            return;
        }
        int r = 3;
        BlockPos.betweenClosedStream((BlockPos)genPos.offset(-r, -25, -r), (BlockPos)genPos.offset(r, 4, r)).forEach(pos -> {
            if (pos.getY() < genPos.getY()) {
                double pct = (double)(genPos.getY() - pos.getY()) / 25.0;
                if (Utils.getDistance((double)pos.getX(), (double)pos.getZ(), (double)genPos.getX(), (double)genPos.getZ()) <= (double)r + 0.5 && 1.0 - pct > rand.nextDouble()) {
                    float block = rand.nextFloat();
                    if ((double)block < 0.1) {
                        world.setBlock(pos, ((BlockBCore)DEContent.INFUSED_OBSIDIAN.get()).defaultBlockState(), 3);
                    } else if ((double)block < 0.4) {
                        world.setBlock(pos, Blocks.NETHER_BRICKS.defaultBlockState(), 3);
                    } else {
                        world.setBlock(pos, Blocks.OBSIDIAN.defaultBlockState(), 3);
                    }
                }
            }
            int relY = pos.getY() - genPos.getY();
            int absRelX = Math.abs(pos.getX() - genPos.getX());
            int absRelZ = Math.abs(pos.getZ() - genPos.getZ());
            if ((absRelX == 2 || absRelZ == 2) && absRelX <= 2 && absRelZ <= 2 && relY < 4 && relY > -1) {
                world.setBlock(pos, Blocks.IRON_BARS.defaultBlockState(), 3);
            }
            if (relY == 4 && absRelX <= 2 && absRelZ <= 2) {
                world.setBlock(pos, Blocks.NETHER_BRICK_SLAB.defaultBlockState(), 3);
            }
        });
    }
}

