/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.blocks.machines.Grinder;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.GrinderMenu;
import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;

public class TileGrinder
extends TileBCore
implements IRSSwitchable,
MenuProvider,
IInteractTile {
    private static FakePlayer cachedFakePlayer;
    public final ManagedBool active = (ManagedBool)this.register((IManagedData)new ManagedBool("active", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE}));
    public final ManagedByte aoe = (ManagedByte)this.register((IManagedData)new ManagedByte("aoe", (int)((byte)this.getMaxAOE()), new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedBool showAOE = (ManagedBool)this.register((IManagedData)new ManagedBool("show_aoe", new DataFlags[]{DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedBool collectItems = (ManagedBool)this.register((IManagedData)new ManagedBool("collect_items", true, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER, DataFlags.CLIENT_CONTROL}));
    public final ManagedBool collectXP = (ManagedBool)this.register((IManagedData)new ManagedBool("collect_xp", true, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER, DataFlags.CLIENT_CONTROL}));
    public final ManagedInt storedXP = (ManagedInt)this.register((IManagedData)new ManagedInt("stored_xp", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER}));
    public TileItemStackHandler itemHandler = new TileItemStackHandler((BlockEntity)this, 2);
    public EntityFilter entityFilter;
    public OPStorage opStorage = new ModularOPStorage(this, 1000000L, 128000L, 0L);
    public Entity targetA = null;
    public float animA = 0.8f;
    public Entity targetB = null;
    public float animB = 0.8f;
    private boolean swordFlipFlop = false;
    public float fanRotation = 0.0f;
    public float fanSpeed = 0.0f;
    public float aoeDisplay = 0.0f;
    public AABB killZone;
    private int coolDown = 0;
    private LivingEntity nextTarget = null;
    private int killRate = 5;

    public TileGrinder(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_GRINDER.get(), pos, state);
        this.enablePlayerAccessTracking(true);
        this.capManager.setManaged("energy", CapabilityOP.BLOCK, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.installIOTracker(this.opStorage);
        this.capManager.setInternalManaged("inventory", Capabilities.ItemHandler.BLOCK, (INBTSerializable)this.itemHandler).saveBoth();
        this.setupPowerSlot((IItemHandler)this.itemHandler, 0, (IOPStorage)this.opStorage, false);
        this.entityFilter = new EntityFilter(true, new FilterType[]{FilterType.HOSTILE, FilterType.TAMED, FilterType.ADULTS, FilterType.ENTITY_TYPE, FilterType.FILTER_GROUP, FilterType.PLAYER});
        this.entityFilter.setDirtyHandler(() -> ((TileGrinder)this).setChanged());
        this.entityFilter.setTypePredicate(e -> e != FilterType.PLAYER || DEConfig.allowGrindingPlayers);
        this.entityFilter.setupServerPacketHandling(() -> this.createClientBoundPacket(0), packet -> this.sendPacketToClients(this.getAccessingPlayers(), (PacketCustom)packet));
        this.entityFilter.setupClientPacketHandling(() -> this.createServerBoundPacket(0));
        this.setClientSidePacketHandler(0, input -> this.entityFilter.receivePacketFromServer(input));
        this.setServerSidePacketHandler(0, (input, player) -> this.entityFilter.receivePacketFromClient(input));
        this.setSavedDataObject("entity_filter", (INBTSerializable)this.entityFilter);
        this.setItemSavedDataObject("entity_filter", (INBTSerializable)this.entityFilter);
        this.aoe.setValidator(value -> (byte)MathHelper.clip((int)value.byteValue(), (int)1, (int)this.getMaxAOE()));
        this.aoe.addValueListener(e -> {
            this.killZone = null;
        });
        this.enableTileDebug();
    }

    public static void register(RegisterCapabilitiesEvent event) {
        TileGrinder.energyCapability((RegisterCapabilitiesEvent)event, DEContent.TILE_GRINDER);
        TileGrinder.capability((RegisterCapabilitiesEvent)event, DEContent.TILE_GRINDER, (BlockCapability)Capabilities.ItemHandler.BLOCK);
    }

    private boolean canExtractItem(int slot, ItemStack stack) {
        return EnergyUtils.isEmptyOrInvalid((ItemStack)stack);
    }

    public void onPlayerOpenContainer(Player player) {
        super.onPlayerOpenContainer(player);
        if (player instanceof ServerPlayer) {
            this.entityFilter.syncClient((ServerPlayer)player);
        }
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            if (this.animA < 1.0f) {
                this.animA += this.getAnimSpeed();
            } else {
                this.targetA = null;
            }
            if (this.animB < 1.0f) {
                this.animB += this.getAnimSpeed();
            } else {
                this.targetB = null;
            }
            this.fanRotation += this.fanSpeed;
            if (this.active.get() && this.fanSpeed < 1.0f) {
                this.fanSpeed = Math.min(this.fanSpeed + 0.03f, 1.0f);
            } else if (!this.active.get() && this.fanSpeed > 0.0f) {
                this.fanSpeed = Math.max(this.fanSpeed - 0.08f, 0.0f);
            }
            this.aoeDisplay = this.showAOE.get() ? (float)MathHelper.approachExp((double)this.aoeDisplay, (double)this.aoe.get(), (double)0.1f) : MathHelper.approachLinear((float)this.aoeDisplay, (float)0.5f, (float)0.15f);
            return;
        }
        if (this.updateActiveState()) {
            if (this.onInterval(20)) {
                this.validateKillZone(false);
                this.handleLootCollection();
            }
            if (this.coolDown > 0) {
                this.debug("Cool down: " + this.coolDown);
                --this.coolDown;
                return;
            }
            this.validateKillZone(false);
            if (this.attackTarget()) {
                this.queNextTarget();
            }
        }
    }

    private boolean updateActiveState() {
        int eph = DEConfig.grinderEnergyPerHeart;
        boolean isActive = this.isTileEnabled();
        if (isActive && this.opStorage.getOPStored() < (long)eph * 50L) {
            isActive = false;
        }
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).setValue((Property)Grinder.ACTIVE, (Comparable)Boolean.valueOf(isActive)));
        return this.active.set(isActive);
    }

    public void validateKillZone(boolean forceReCalc) {
        if (forceReCalc || this.killZone == null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            Direction facing = (Direction)state.getValue((Property)Grinder.FACING);
            int aoe = this.aoe.get();
            BlockPos pos1 = this.worldPosition.offset(-(aoe - 1), -(aoe - 1), -(aoe - 1));
            BlockPos pos2 = this.worldPosition.offset(aoe - 1, aoe - 1, aoe - 1);
            pos1 = pos1.offset(facing.getStepX() * aoe, 0, facing.getStepZ() * aoe);
            pos2 = pos2.offset(facing.getStepX() * aoe, 0, facing.getStepZ() * aoe);
            this.killZone = AABB.encapsulatingFullBlocks((BlockPos)pos1, (BlockPos)pos2);
            this.debug("Kill zone updated: " + String.valueOf(this.killZone));
        }
    }

    private boolean attackTarget() {
        if (this.nextTarget == null || !this.nextTarget.isAlive()) {
            this.debug("Next target is null or dead: " + String.valueOf(this.nextTarget));
            return true;
        }
        ItemStack weapon = this.itemHandler.getStackInSlot(1);
        this.getFakePlayer().setItemInHand(InteractionHand.MAIN_HAND, weapon);
        int eph = DEConfig.grinderEnergyPerHeart;
        float health = this.nextTarget.getHealth();
        if (health < 5.0f) {
            health = 5.0f;
        }
        int cost = (int)(health * (float)eph);
        boolean willKill = false;
        if ((long)cost > this.opStorage.getOPStored()) {
            cost = this.opStorage.getEnergyStored();
        } else {
            willKill = true;
        }
        float damage = willKill ? 6.805647E37f : (float)cost / (float)eph * 1.1f;
        DamageSource source = this.level.damageSources().playerAttack((Player)this.getFakePlayer());
        if (this.nextTarget.hurt(source, damage)) {
            if (!weapon.isEmpty()) {
                ItemStack justInCase = weapon.copy();
                justInCase.setDamageValue(justInCase.getMaxDamage() - 1);
                weapon.hurtAndBreak(1, (ServerLevel)this.level, (ServerPlayer)this.getFakePlayer(), item -> this.itemHandler.setStackInSlot(1, justInCase));
            }
            this.debug("Dealt " + damage + " damage to entity: " + String.valueOf(this.nextTarget));
            this.nextTarget = null;
            this.opStorage.modifyEnergyStored((long)(-cost));
            return true;
        }
        this.debug("Failed to deal damage to entity: " + this.nextTarget.getType().getDescription().getString() + " Waiting 3 ticks...");
        if (!this.killZone.intersects(this.nextTarget.getBoundingBox())) {
            this.nextTarget = null;
        }
        return false;
    }

    private void queNextTarget() {
        List entitiesInRange = this.level.getEntitiesOfClass(LivingEntity.class, this.killZone, this.entityFilter.predicate());
        this.debug("Searching for next target, " + entitiesInRange.size() + " targets in range");
        boolean foundInvulnerable = false;
        while (!entitiesInRange.isEmpty()) {
            LivingEntity randEntity = (LivingEntity)entitiesInRange.remove(this.level.random.nextInt(entitiesInRange.size()));
            this.debug("Checking Target: " + String.valueOf(randEntity));
            if (!this.isValidEntity(randEntity)) continue;
            this.debug("Found valid target: " + String.valueOf(randEntity));
            if (randEntity.isInvulnerable()) {
                this.debug("Target is invulnerable! searching for softer target...");
                foundInvulnerable = true;
                continue;
            }
            this.nextTarget = randEntity;
            this.sendPacketToChunk(output -> output.writeInt(this.nextTarget.getId()), 1);
            this.level.playSound(null, this.worldPosition, (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.BLOCKS, 1.0f, 0.55f + this.level.random.nextFloat() * 0.1f);
            this.coolDown = this.killRate;
            return;
        }
        this.coolDown = foundInvulnerable ? 5 : 100;
        this.debug("No attachable target found. Will check again in " + this.coolDown + " Ticks");
        this.nextTarget = null;
    }

    private boolean isValidEntity(LivingEntity livingBase) {
        if (!livingBase.isAlive()) {
            this.debug("Target Invalid: " + String.valueOf(livingBase) + ", [Already Dead]");
            return false;
        }
        if (livingBase instanceof Player && !DEConfig.allowGrindingPlayers) {
            this.debug("Target Invalid: " + String.valueOf(livingBase) + ", [Is Player]");
            return false;
        }
        if (DEConfig.grinderBlackList.isEmpty()) {
            return true;
        }
        ResourceLocation reg = BuiltInRegistries.ENTITY_TYPE.getKey((Object)livingBase.getType());
        return reg == null || !DEConfig.grinderBlackList.contains(reg.toString());
    }

    private void handleLootCollection() {
        List xp = this.level.getEntitiesOfClass(ExperienceOrb.class, this.killZone.inflate(4.0, 4.0, 4.0));
        this.debug("Detected: " + xp.size() + " XP entities");
        for (ExperienceOrb orb : xp) {
            if (!orb.isAlive()) continue;
            if (this.collectXP.get() && this.storedXP.get() + orb.value <= this.getXPStorageCapacity()) {
                this.storedXP.add(orb.value);
                orb.discard();
                continue;
            }
            if (orb.age >= 5400) continue;
            orb.age = 5700;
        }
        if (this.collectItems.get()) {
            List items = this.level.getEntitiesOfClass(ItemEntity.class, this.killZone.inflate(1.0, 1.0, 1.0));
            this.debug("Detected: " + items.size() + " Item entities");
            for (Direction dir : Direction.values()) {
                IItemHandler handler;
                BlockEntity target = this.level.getBlockEntity(this.worldPosition.relative(dir));
                if (target == null || (handler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, target.getBlockPos(), null, target, (Object)dir.getOpposite())) == null) continue;
                Iterator i = items.iterator();
                while (i.hasNext()) {
                    ItemEntity next = (ItemEntity)i.next();
                    if (!next.isAlive()) continue;
                    ItemStack stack = next.getItem();
                    if ((stack = InventoryUtils.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false)).isEmpty()) {
                        next.setItem(ItemStack.EMPTY);
                        next.discard();
                        i.remove();
                        continue;
                    }
                    next.setItem(stack);
                }
            }
        }
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        super.receivePacketFromClient(data, client, id);
        if (id == 1) {
            int levels = 0;
            switch (data.readByte()) {
                case 0: {
                    client.giveExperiencePoints(this.storedXP.get());
                    this.storedXP.set(0);
                    return;
                }
                case 1: {
                    levels = 1;
                    break;
                }
                case 2: {
                    levels = 5;
                    break;
                }
                case 3: {
                    levels = 10;
                }
            }
            for (int i = 0; i < levels; ++i) {
                int xp = Math.min(client.getXpNeededForNextLevel(), this.storedXP.get());
                this.storedXP.subtract(xp);
                client.giveExperiencePoints(xp);
            }
        }
        this.coolDown = this.killRate;
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        Entity target;
        super.receivePacketFromServer(data, id);
        if (id == 1 && (target = this.level.getEntity(data.readInt())) != null) {
            if (this.swordFlipFlop) {
                this.targetA = target;
                this.animA = 0.0f;
            } else {
                this.targetB = target;
                this.animB = 0.0f;
            }
            this.swordFlipFlop = !this.swordFlipFlop;
        }
    }

    public int getMaxAOE() {
        return 4;
    }

    public int getXPStorageCapacity() {
        return 8192;
    }

    public float getAnimSpeed() {
        return 0.425f / (float)this.killRate;
    }

    public FakePlayer getFakePlayer() {
        if (cachedFakePlayer == null) {
            cachedFakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.level), (GameProfile)new GameProfile(UUID.fromString("5b5689b9-e43d-4282-a42a-dc916f3616b7"), "Draconic Evolution Grinder"));
        }
        return cachedFakePlayer;
    }

    public void onNeighborChange(BlockPos neighbor) {
        super.onNeighborChange(neighbor);
        if (this.coolDown > this.killRate) {
            this.updateActiveState();
            this.validateKillZone(true);
            this.coolDown = this.killRate;
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new GrinderMenu(currentWindowIndex, playerInventory, this);
    }

    public InteractionResult useWithoutItem(BlockState state, Player player, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            player.openMenu((MenuProvider)this, this.worldPosition);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }
}

