/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.brandonscore.lib.CustomTabHandling;
import com.brandon3055.brandonscore.multiblock.StructurePart;
import com.brandon3055.draconicevolution.blocks.tileentity.MultiBlockController;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStructureBlock;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;

public class StructureBlock
extends EntityBlockBCore
implements StructurePart,
CustomTabHandling {
    public static boolean buildingLock = false;

    public StructureBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.setBlockEntity(() -> DEContent.TILE_STRUCTURE_BLOCK.get(), false);
        this.dontSpawnOnMe();
        this.setLightTransparent();
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        this.neighborChanged(world, pos);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.neighborChanged((LevelReader)world, pos);
    }

    private void neighborChanged(LevelReader world, BlockPos pos) {
        TileStructureBlock tile;
        if (buildingLock) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TileStructureBlock && ((tile = (TileStructureBlock)blockEntity).getController() == null || !tile.getController().isStructureValid())) {
            tile.debug("Structure Block: Reverting from neighborChanged");
            tile.revert();
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileStructureBlock) {
            TileStructureBlock structureTile = (TileStructureBlock)tile;
            ResourceLocation blockName = structureTile.blockName.get();
            if (blockName != null) {
                Block block = (Block)BuiltInRegistries.BLOCK.get(blockName);
                MultiBlockController controller = structureTile.getController();
                world.removeBlock(pos, false);
                if (block != Blocks.AIR && !player.getAbilities().instabuild) {
                    StructureBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)block));
                }
                if (controller != null) {
                    controller.validateStructure();
                }
            }
        }
        this.playerWillDestroy(world, pos, state, player);
        return true;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileStructureBlock) {
            TileStructureBlock structureTile = (TileStructureBlock)tile;
            ResourceLocation blockName = structureTile.blockName.get();
            if (blockName != null) {
                Block block = (Block)BuiltInRegistries.BLOCK.get(blockName);
                return new ItemStack((ItemLike)block);
            }
        }
        return ItemStack.EMPTY;
    }

    public VoxelShape getCollisionShape(BlockState p_60572_, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        return Shapes.block();
    }

    public VoxelShape getOcclusionShape(BlockState p_60578_, BlockGetter p_60579_, BlockPos p_60580_) {
        return Shapes.block();
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = getter.getBlockEntity(pos);
        if (blockEntity instanceof TileStructureBlock) {
            TileStructureBlock tile = (TileStructureBlock)blockEntity;
            return tile.getShape(context);
        }
        return super.getShape(state, getter, pos, context);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileStructureBlock) {
            TileStructureBlock tile = (TileStructureBlock)blockEntity;
            tile.debug("Structure Block: Block Tick doRevert");
            tile.doRevert();
        }
        super.tick(state, level, pos, random);
    }

    public boolean is(Level level, BlockPos pos, TagKey<Block> key) {
        return StructureBlock.getBlock(level, pos).defaultBlockState().is(key);
    }

    public boolean is(Level level, BlockPos pos, Block block) {
        return StructureBlock.getBlock(level, pos).defaultBlockState().is(block);
    }

    public static Block getBlock(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TileStructureBlock) {
            TileStructureBlock tile = (TileStructureBlock)blockEntity;
            ResourceLocation name = tile.blockName.get();
            if (name != null) {
                return (Block)BuiltInRegistries.BLOCK.get(name);
            }
        }
        return Blocks.AIR;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        TileStructureBlock tile;
        Block block;
        float f = state.getDestroySpeed(getter, pos);
        BlockEntity blockEntity = getter.getBlockEntity(pos);
        if (blockEntity instanceof TileStructureBlock && (block = (tile = (TileStructureBlock)blockEntity).getOriginalBlock()) != Blocks.AIR) {
            f = block.defaultBlockState().getDestroySpeed(getter, pos);
        }
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = IModularItem.isCorrectToolForDrops(player.getMainHandItem(), state) ? 30 : 100;
        return player.getDigSpeed(state, pos) / f / (float)i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean renderSelectionBox(RenderHighlightEvent.Block event, Level level) {
        BlockEntity blockEntity = level.getBlockEntity(event.getTarget().getBlockPos());
        if (blockEntity instanceof TileStructureBlock) {
            TileStructureBlock tile = (TileStructureBlock)blockEntity;
            return tile.renderSelectionBox(event);
        }
        return true;
    }
}

