/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import quek.undergarden.block.GlitterkelpBlock;
import quek.undergarden.block.GlitterkelpPlantBlock;
import quek.undergarden.registry.UGBlocks;

public class GlitterkelpFeature
extends Feature<NoneFeatureConfiguration> {
    public GlitterkelpFeature(Codec<NoneFeatureConfiguration> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        int i = 0;
        int oceanY = 32;
        BlockPos blockpos = new BlockPos(pos.getX(), pos.getY(), pos.getZ());
        if (pos.getY() < oceanY && level.getBlockState(blockpos).is(Blocks.WATER)) {
            BlockState kelp = ((GlitterkelpBlock)((Object)UGBlocks.GLITTERKELP.get())).defaultBlockState();
            BlockState kelpTop = ((GlitterkelpPlantBlock)((Object)UGBlocks.GLITTERKELP_PLANT.get())).defaultBlockState();
            int k = 1 + random.nextInt(10);
            for (int l = 0; l <= k; ++l) {
                if (level.getBlockState(blockpos).getBlock() == Blocks.WATER && level.getBlockState(blockpos.above()).getBlock() == Blocks.WATER && kelpTop.canSurvive((LevelReader)level, blockpos)) {
                    if (l == k) {
                        level.setBlock(blockpos, (BlockState)kelp.setValue((Property)GlitterkelpBlock.AGE, (Comparable)Integer.valueOf(random.nextInt(4) + 20)), 2);
                        ++i;
                    } else {
                        level.setBlock(blockpos, kelpTop, 2);
                    }
                } else if (l > 0) {
                    BlockPos blockpos1 = blockpos.below();
                    if (!kelp.canSurvive((LevelReader)level, blockpos1) || level.getBlockState(blockpos1.below()).getBlock() == UGBlocks.GLITTERKELP.get()) break;
                    level.setBlock(blockpos1, (BlockState)kelp.setValue((Property)GlitterkelpBlock.AGE, (Comparable)Integer.valueOf(random.nextInt(4) + 20)), 2);
                    ++i;
                    break;
                }
                blockpos = blockpos.above();
            }
        }
        return i > 0;
    }
}

