/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.world.gen.feature.config.AncientRootConfiguration;

public class AncientRootFeature
extends Feature<AncientRootConfiguration> {
    public AncientRootFeature(Codec<AncientRootConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<AncientRootConfiguration> context) {
        BlockPos pos = context.origin();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        if (level.isEmptyBlock(pos) && !level.isEmptyBlock(pos.above())) {
            BlockPos.MutableBlockPos posMutable = pos.mutable();
            BlockPos.MutableBlockPos posMutable2 = pos.mutable();
            while (level.isEmptyBlock((BlockPos)posMutable) && level.getFluidState((BlockPos)posMutable).isEmpty()) {
                if (level.isOutsideBuildHeight((BlockPos)posMutable)) {
                    return true;
                }
                level.setBlock((BlockPos)posMutable, this.rootState(random, context), 2);
                level.setBlock((BlockPos)posMutable2.setWithOffset((Vec3i)posMutable, Direction.NORTH), this.rootState(random, context), 2);
                level.setBlock((BlockPos)posMutable2.setWithOffset((Vec3i)posMutable, Direction.SOUTH), this.rootState(random, context), 2);
                level.setBlock((BlockPos)posMutable2.setWithOffset((Vec3i)posMutable, Direction.WEST), this.rootState(random, context), 2);
                level.setBlock((BlockPos)posMutable2.setWithOffset((Vec3i)posMutable, Direction.EAST), this.rootState(random, context), 2);
                if (random.nextInt(3) == 0) {
                    posMutable.move(Direction.NORTH);
                    level.setBlock((BlockPos)posMutable2.setWithOffset((Vec3i)posMutable, Direction.NORTH), this.rootState(random, context), 2);
                }
                if (random.nextInt(3) == 0) {
                    posMutable.move(Direction.SOUTH);
                    level.setBlock((BlockPos)posMutable2.setWithOffset((Vec3i)posMutable, Direction.SOUTH), this.rootState(random, context), 2);
                }
                if (random.nextInt(3) == 0) {
                    posMutable.move(Direction.WEST);
                    level.setBlock((BlockPos)posMutable2.setWithOffset((Vec3i)posMutable, Direction.WEST), this.rootState(random, context), 2);
                }
                if (random.nextInt(3) == 0) {
                    posMutable.move(Direction.EAST);
                    level.setBlock((BlockPos)posMutable2.setWithOffset((Vec3i)posMutable, Direction.EAST), this.rootState(random, context), 2);
                }
                posMutable.move(Direction.DOWN);
            }
            return true;
        }
        return false;
    }

    private BlockState rootState(RandomSource random, FeaturePlaceContext<AncientRootConfiguration> context) {
        return random.nextInt(((AncientRootConfiguration)context.config()).rogdoricProbability()) == 0 ? ((RotatedPillarBlock)UGBlocks.ROGDORIC_ANCIENT_ROOT.get()).defaultBlockState() : ((RotatedPillarBlock)UGBlocks.ANCIENT_ROOT.get()).defaultBlockState();
    }
}

