/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import quek.undergarden.block.portal.UndergardenPortalShape;
import quek.undergarden.item.CatalystItem;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGSoundEvents;

public class CrumblingCatalystItem
extends CatalystItem {
    public CrumblingCatalystItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().dimension() == Level.OVERWORLD || context.getLevel().dimension() == UGDimensions.UNDERGARDEN_LEVEL) {
            BlockPos framePos = context.getClickedPos().relative(context.getClickedFace());
            Optional<UndergardenPortalShape> optional = CrumblingCatalystItem.findPortalShape((LevelAccessor)context.getLevel(), framePos, shape -> shape.isValid() && shape.getPortalBlocks() == 0, Direction.Axis.X);
            if (optional.isPresent()) {
                optional.get().createPortalBlocks();
                context.getLevel().playSound(context.getPlayer(), context.getClickedPos(), (SoundEvent)UGSoundEvents.UNDERGARDEN_PORTAL_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (context.getPlayer() != null && !context.getLevel().isClientSide) {
                    context.getItemInHand().hurtAndBreak(1, (LivingEntity)context.getPlayer(), LivingEntity.getSlotForHand((InteractionHand)context.getPlayer().getUsedItemHand()));
                }
                return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide());
            }
        }
        return InteractionResult.FAIL;
    }
}

