/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import quek.undergarden.entity.projectile.Blisterbomb;
import quek.undergarden.registry.UGSoundEvents;

public class BlisterbombItem
extends Item
implements ProjectileItem {
    public BlisterbombItem() {
        super(new Item.Properties().stacksTo(8));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        level.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), (SoundEvent)UGSoundEvents.BLISTERBOMB_THROW.get(), SoundSource.NEUTRAL, 0.5f, 1.0f);
        playerIn.getCooldowns().addCooldown((Item)this, 50);
        if (!level.isClientSide) {
            Blisterbomb blisterbomb = new Blisterbomb(level, (LivingEntity)playerIn);
            blisterbomb.setItem(itemstack);
            blisterbomb.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)blisterbomb);
        }
        playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!playerIn.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResultHolder.success((Object)itemstack);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return new Blisterbomb(level, pos.x(), pos.y(), pos.z());
    }
}

