/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.projectile;

import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import quek.undergarden.entity.Minion;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;

public class MinionProjectile
extends ThrowableItemProjectile {
    public MinionProjectile(EntityType<? extends MinionProjectile> type, Level level) {
        super(type, level);
    }

    public MinionProjectile(Level level, LivingEntity shooter) {
        super((EntityType)UGEntityTypes.MINION_PROJECTILE.get(), shooter, level);
    }

    protected Item getDefaultItem() {
        return (Item)UGItems.FORGOTTEN_NUGGET.get();
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)this.getDefaultItem())), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity living;
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity && !((living = (LivingEntity)entity) instanceof Minion)) {
            living.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 10.0f);
        }
    }
}

