/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class MysteriousPot
extends PathfinderMob {
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(MysteriousPot.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final EntityDimensions ACTIVE_DIMENSIONS = EntityDimensions.fixed((float)0.8f, (float)1.25f).withEyeHeight(0.2f);
    protected int hideCooldown;
    private int prevInactiveWiggleTicks;
    private int inactiveWiggleTicks;

    public MysteriousPot(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.SAFE_FALL_DISTANCE, 5.0).add(Attributes.FALL_DAMAGE_MULTIPLIER, 2.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, entity -> true, 16.0f, 1.25, 1.75, EntitySelector.NO_SPECTATORS::test));
        this.goalSelector.addGoal(1, (Goal)new HideAgainGoal(this));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ACTIVE, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (ACTIVE.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    public boolean canBeCollidedWith() {
        return !this.isActive();
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isActive() ? this.ACTIVE_DIMENSIONS : super.getDefaultDimensions(pose);
    }

    public void tick() {
        super.tick();
        if (this.hideCooldown > 0) {
            --this.hideCooldown;
        }
        if (this.level().isClientSide()) {
            this.prevInactiveWiggleTicks = this.inactiveWiggleTicks;
            if (this.inactiveWiggleTicks > 0) {
                --this.inactiveWiggleTicks;
            }
            if (!this.isActive() && this.tickCount % 100 == 0 && this.getRandom().nextInt(5) == 0) {
                this.prevInactiveWiggleTicks = 10;
                this.inactiveWiggleTicks = 10;
            }
        }
    }

    public float getInactiveWiggleTicks(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.prevInactiveWiggleTicks, (float)this.inactiveWiggleTicks);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("active", this.isActive());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setActive(compound.getBoolean("active"));
    }

    public boolean isActive() {
        return (Boolean)this.getEntityData().get(ACTIVE);
    }

    public void setActive(boolean active) {
        this.getEntityData().set(ACTIVE, (Object)active);
    }

    protected boolean isImmobile() {
        return !this.isActive() || super.isImmobile();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && !this.isActive() && amount > 0.0f) {
            float yRot = this.getNearestViewDirection().toYRot();
            if (source.getDirectEntity() != null) {
                double d0 = source.getDirectEntity().getX() - this.getX();
                double d2 = source.getDirectEntity().getZ() - this.getZ();
                float rawRot = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                yRot = Math.round(rawRot / 90.0f) * 90;
            }
            this.yRotO = yRot;
            this.setYRot(this.yRotO);
            this.yHeadRotO = yRot;
            this.setYHeadRot(this.yHeadRotO);
            this.yBodyRot = this.yBodyRotO = yRot;
            this.jumpFromGround();
            this.setActive(true);
            this.hideCooldown = 200;
            return false;
        }
        if (source.getWeaponItem() != null && source.getWeaponItem().is(ItemTags.BREAKS_DECORATED_POTS)) {
            amount *= 2.0f;
        }
        return super.hurt(source, amount);
    }

    static class HideAgainGoal
    extends Goal {
        private final MysteriousPot pot;

        public HideAgainGoal(MysteriousPot pot) {
            this.pot = pot;
        }

        public boolean canUse() {
            if (this.pot.hideCooldown <= 0 && this.pot.isActive() && this.pot.getNavigation().isDone()) {
                List nearPlayers = this.pot.level().getNearbyPlayers(TargetingConditions.forCombat(), (LivingEntity)this.pot, this.pot.getBoundingBox().inflate(16.0, 16.0, 16.0));
                if (nearPlayers.isEmpty()) {
                    return true;
                }
                for (Player player : nearPlayers) {
                    if (!this.pot.hasLineOfSight((Entity)player)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            this.pot.moveTo(this.pot.blockPosition(), 0.0f, 0.0f);
            this.pot.setActive(false);
        }
    }
}

