/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import quek.undergarden.entity.monster.stoneborn.AbstractStoneborn;
import quek.undergarden.registry.UGCriteria;

public class StonebornTradeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, AbstractStoneborn stoneborn, ItemStack stack) {
        LootContext lootcontext = EntityPredicate.createContext((ServerPlayer)player, (Entity)stoneborn);
        this.trigger(player, instance -> instance.matches(lootcontext, stack));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> stoneborn, Optional<ItemPredicate> item) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_311449_ -> p_311449_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("stoneborn").forGetter(TriggerInstance::stoneborn), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(TriggerInstance::item)).apply((Applicative)p_311449_, TriggerInstance::new));

        public static Criterion<?> tradeWithStoneborn() {
            return ((StonebornTradeTrigger)((Object)UGCriteria.STONEBORN_TRADE.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.empty(), Optional.empty()));
        }

        public boolean matches(LootContext context, ItemStack stack) {
            if (this.stoneborn().isPresent() && !this.stoneborn().get().matches(context)) {
                return false;
            }
            return this.item().isEmpty() || this.item().get().test(stack);
        }
    }
}

