/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.compat.emi.recipe;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import quek.undergarden.compat.emi.UGEmiPlugin;
import quek.undergarden.component.RogdoriumInfusion;
import quek.undergarden.recipe.InfusingRecipe;
import quek.undergarden.registry.UGDataComponents;

public class UGEmiInfusingRecipe
extends BasicEmiRecipe {
    private static final ResourceLocation INFUSER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"undergarden", (String)"textures/gui/container/infuser/infuser.png");
    private final InfusingRecipe recipe;

    public UGEmiInfusingRecipe(RecipeHolder<InfusingRecipe> recipe) {
        super(UGEmiPlugin.INFUSING_CATEGORY, recipe.id(), 126, 57);
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.registryAccess();
        NonNullList recipeIngredients = ((InfusingRecipe)recipe.value()).getIngredients();
        this.recipe = (InfusingRecipe)recipe.value();
        this.inputs.add(EmiIngredient.of(Arrays.stream(((Ingredient)recipeIngredients.getFirst()).getItems()).map(EmiStack::of).toList()));
        this.inputs.add(EmiIngredient.of(this.recipe.getRecipeSlotType().getValidItems()));
        this.outputs.add(EmiStack.of((ItemStack)((InfusingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)registryAccess)));
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(INFUSER_TEXTURE, 0, 0, 126, 57, 25, 16);
        widgets.addSlot((EmiIngredient)this.inputs.getFirst(), 54, 0).drawBack(false);
        InfusingRecipe.SlotType slot = this.recipe.getRecipeSlotType();
        widgets.addSlot(EmiIngredient.of(slot.getValidItems()), (slot.getSlotIndex() - 1) * 108, 36).drawBack(false);
        if (((EmiStack)this.outputs.getFirst()).isEmpty()) {
            widgets.addSlot(EmiIngredient.of(((EmiIngredient)this.inputs.getFirst()).getEmiStacks().stream().map(stack -> {
                ItemStack copy = stack.getItemStack().copy();
                copy.set(UGDataComponents.ROGDORIUM_INFUSION, (Object)RogdoriumInfusion.setInfusionAmount(56));
                return EmiStack.of((ItemStack)copy);
            }).toList()), 50, 31).drawBack(false).large(true).recipeContext((EmiRecipe)this);
        } else {
            widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 50, 31).drawBack(false).large(true).recipeContext((EmiRecipe)this);
        }
        this.drawExperience(widgets);
        this.drawCookTime(widgets);
    }

    protected void drawExperience(WidgetHolder widgets) {
        float experience = this.recipe.experience();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.translatable((String)"gui.undergarden.jei.category.infusing.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.getInstance();
            Font fontRenderer = minecraft.font;
            int stringWidth = fontRenderer.width((FormattedText)experienceString);
            widgets.addText((Component)experienceString, this.getDisplayWidth() - stringWidth, -1, -8355712, false);
        }
    }

    protected void drawCookTime(WidgetHolder widgets) {
        int infusingTime = this.recipe.infusingTime();
        if (infusingTime > 0) {
            int infusingTimeSeconds = infusingTime / 20;
            MutableComponent timeString = Component.translatable((String)"gui.undergarden.jei.category.infusing.time.seconds", (Object[])new Object[]{infusingTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font fontRenderer = minecraft.font;
            int stringWidth = fontRenderer.width((FormattedText)timeString);
            widgets.addText((Component)timeString, this.getDisplayWidth() - stringWidth - 20, 45, -8355712, false);
        }
    }
}

