/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import quek.undergarden.Undergarden;
import quek.undergarden.client.model.MysteriousPotModel;
import quek.undergarden.client.model.PotModel;
import quek.undergarden.client.model.UGModelLayers;
import quek.undergarden.client.render.blockentity.DepthrockPotRenderer;
import quek.undergarden.client.render.layer.BasicEyesLayer;
import quek.undergarden.entity.animal.MysteriousPot;

public class MysteriousPotRenderer
extends MobRenderer<MysteriousPot, MysteriousPotModel> {
    private static final ResourceLocation MYSTERIOUS_POT = Undergarden.prefix("textures/entity/potguy.png");
    private static final RenderType MYSTERIOUS_POT_EYES = RenderType.eyes((ResourceLocation)Undergarden.prefix("textures/entity/potguy_eyes.png"));
    private final PotModel inactiveModel;

    public MysteriousPotRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MysteriousPotModel(context.bakeLayer(UGModelLayers.LIVING_POT)), 0.3f);
        this.addLayer((RenderLayer)new BasicEyesLayer(this, MYSTERIOUS_POT_EYES, MysteriousPot::isActive));
        this.inactiveModel = new PotModel(context.bakeLayer(UGModelLayers.POT));
    }

    public void render(MysteriousPot entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        if (!entity.isActive()) {
            stack.pushPose();
            stack.scale(-1.0f, -1.0f, 1.0f);
            stack.translate(-0.5f, 0.0f, -0.5f);
            float wiggle = entity.getInactiveWiggleTicks(partialTicks) / 10.0f;
            float f5 = Mth.sin((float)(-wiggle * 4.0f * (float)Math.PI)) * 0.125f;
            float f6 = 1.0f - wiggle;
            stack.rotateAround(Axis.YP.rotation(f5 * f6), 0.5f, 0.0f, 0.5f);
            stack.translate(0.5f, -1.501f, 0.5f);
            this.inactiveModel.renderToBuffer(stack, buffer.getBuffer(this.inactiveModel.renderType(DepthrockPotRenderer.TEXTURE)), light, OverlayTexture.NO_OVERLAY);
            stack.popPose();
        } else {
            super.render((LivingEntity)entity, entityYaw, partialTicks, stack, buffer, light);
        }
    }

    public ResourceLocation getTextureLocation(MysteriousPot entity) {
        return MYSTERIOUS_POT;
    }
}

