/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.monster.cavern.Sploogie;

public class SploogieModel<T extends Sploogie>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart bodySegment1;
    private final ModelPart bodySegment2;
    private final ModelPart bodySegment3;

    public SploogieModel(ModelPart root) {
        this.head = root.getChild("head");
        this.bodySegment1 = root.getChild("bodySegment1");
        this.bodySegment2 = root.getChild("bodySegment2");
        this.bodySegment3 = root.getChild("bodySegment3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 30).addBox(4.0f, -2.0f, -9.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 30).mirror().addBox(-8.0f, -2.0f, -9.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 0).addBox(-5.0f, -4.0f, -8.0f, 10.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition spine1 = head.addOrReplaceChild("spine1", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -7.0f, 0.0f, 4.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-5.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(12, 34).addBox(-2.0f, -5.0f, -4.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)-8.0f));
        PartDefinition bodySegment1 = partdefinition.addOrReplaceChild("bodySegment1", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -4.0f, 0.0f, 8.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)0.0f));
        PartDefinition spine2 = bodySegment1.addOrReplaceChild("spine2", CubeListBuilder.create().texOffs(0, 16).addBox(-1.5f, -6.0f, 0.0f, 3.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)3.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition bodySegment2 = partdefinition.addOrReplaceChild("bodySegment2", CubeListBuilder.create().texOffs(24, 24).addBox(-3.0f, -3.0f, 0.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)7.0f));
        PartDefinition spine3 = bodySegment2.addOrReplaceChild("spine3", CubeListBuilder.create().texOffs(23, 16).addBox(-1.0f, -4.0f, 0.0f, 2.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)3.0f, (float)-1.1345f, (float)0.0f, (float)0.0f));
        PartDefinition bodySegment3 = partdefinition.addOrReplaceChild("bodySegment3", CubeListBuilder.create().texOffs(30, 16).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)13.0f));
        PartDefinition spine4 = bodySegment3.addOrReplaceChild("spine4", CubeListBuilder.create().texOffs(23, 20).addBox(-0.5f, -3.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)2.0f, (float)-1.309f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.x = Mth.cos((float)(limbSwing * 0.9f + 0.9424779f)) * (float)Math.PI * 0.05f * (1.0f + limbSwingAmount);
        this.bodySegment1.yRot = Mth.cos((float)(limbSwing * 0.9f + 0.9424779f)) * (float)Math.PI * 0.05f * (1.0f + limbSwingAmount);
        this.bodySegment2.yRot = Mth.cos((float)(limbSwing * 0.9f + 0.47123894f)) * (float)Math.PI * 0.05f * ((float)(1 + Math.abs(-1)) + limbSwingAmount);
        this.bodySegment3.yRot = Mth.cos((float)(limbSwing * 0.9f + 0.0f)) * (float)Math.PI * 0.05f * ((float)(1 + Math.abs(-2)) + limbSwingAmount);
        this.bodySegment1.x = Mth.cos((float)(limbSwing * 0.9f + 0.9424779f)) * (float)Math.PI * 0.05f * (1.0f + limbSwingAmount);
        this.bodySegment2.x = Mth.cos((float)(limbSwing * 0.9f + 0.47123894f)) * (float)Math.PI * 0.05f * ((float)(1 + Math.abs(-1)) + limbSwingAmount);
        this.bodySegment3.x = Mth.cos((float)(limbSwing * 0.9f + 0.0f)) * (float)Math.PI * 0.05f * ((float)(1 + Math.abs(-2)) + limbSwingAmount);
    }

    public Iterable<ModelPart> parts() {
        return ImmutableList.of((Object)this.head, (Object)this.bodySegment1, (Object)this.bodySegment2, (Object)this.bodySegment3);
    }
}

