/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.client.model.animation.RotbelcherAnimation;
import quek.undergarden.entity.monster.rotspawn.Rotbelcher;

public class RotbelcherModel<T extends Rotbelcher>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart torso;
    private final ModelPart gut;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart head;
    private final ModelPart jaw;

    public RotbelcherModel(ModelPart root) {
        this.root = root.getChild("root");
        this.rightLeg = this.root.getChild("rightLeg");
        this.leftLeg = this.root.getChild("leftLeg");
        this.torso = this.root.getChild("torso");
        this.gut = this.torso.getChild("gut");
        this.rightArm = this.torso.getChild("rightArm");
        this.leftArm = this.torso.getChild("leftArm");
        this.head = this.torso.getChild("head");
        this.jaw = this.head.getChild("jaw");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition rightLeg = root.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(42, 0).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 20.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)4.0f, (float)0.0f));
        PartDefinition leftLeg = root.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(42, 0).mirror().addBox(0.0f, 0.0f, -1.0f, 2.0f, 20.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)4.0f, (float)0.0f));
        PartDefinition torso = root.addOrReplaceChild("torso", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)1.0f));
        PartDefinition cube_r1 = torso.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 27).addBox(-5.0f, -14.0f, -2.0f, 10.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-1.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition gut = torso.addOrReplaceChild("gut", CubeListBuilder.create().texOffs(0, 48).addBox(-4.0f, -6.0f, -5.0f, 8.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition rightArm = torso.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(32, 0).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 20.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-14.0f, (float)-2.0f));
        PartDefinition leftArm = torso.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(32, 0).mirror().addBox(0.0f, -1.0f, -1.0f, 2.0f, 20.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)-14.0f, (float)-2.0f));
        PartDefinition head = torso.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-15.0f, (float)-1.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-4.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition cube_r3 = jaw.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -2.0f, -5.0f, 8.0f, 2.0f, 9.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-4.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Rotbelcher entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = 0.0873f + headPitch * ((float)Math.PI / 180);
        if (!entity.isCharging()) {
            this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.rightArm.zRot = 0.0f;
            this.leftArm.zRot = 0.0f;
            AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        }
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.animate(entity.attackAnimation, RotbelcherAnimation.ATTACK, ageInTicks);
        this.animate(entity.shootAnimation, RotbelcherAnimation.SHOOT, ageInTicks);
    }

    public ModelPart root() {
        return this.root;
    }
}

