/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.Mog;

public class MogModel<E extends Mog>
extends AgeableListModel<E> {
    private final ModelPart frontLegLeft;
    private final ModelPart frontLegRight;
    private final ModelPart backLegRight;
    private final ModelPart backLegLeft;
    private final ModelPart head;
    private final ModelPart body;

    public MogModel(ModelPart root) {
        this.frontLegLeft = root.getChild("frontLegLeft");
        this.frontLegRight = root.getChild("frontLegRight");
        this.backLegRight = root.getChild("backLegRight");
        this.backLegLeft = root.getChild("backLegLeft");
        this.head = root.getChild("head");
        this.body = root.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition frontLegLeft = partdefinition.addOrReplaceChild("frontLegLeft", CubeListBuilder.create().texOffs(32, 36).mirror().addBox(0.0f, 0.0f, -3.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)20.0f, (float)-2.0f));
        PartDefinition frontLegRight = partdefinition.addOrReplaceChild("frontLegRight", CubeListBuilder.create().texOffs(20, 36).addBox(-3.0f, 0.0f, -3.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)20.0f, (float)-2.0f));
        PartDefinition backLegRight = partdefinition.addOrReplaceChild("backLegRight", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, 0.0f, 0.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)20.0f, (float)2.0f));
        PartDefinition backLegLeft = partdefinition.addOrReplaceChild("backLegLeft", CubeListBuilder.create().texOffs(36, 0).mirror().addBox(4.0f, 0.0f, 0.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.0f, (float)20.0f, (float)2.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(26, 26).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)-6.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 35).addBox(0.0f, -21.0f, -4.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-6.0f, -17.0f, -6.0f, 12.0f, 14.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 26).addBox(-4.0f, -19.0f, -3.0f, 6.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.frontLegLeft, (Object)this.frontLegRight, (Object)this.backLegLeft, (Object)this.backLegRight);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.body.zRot = 0.1f * Mth.sin((float)(limbSwing * 2.0f)) * 4.0f * limbSwingAmount;
        this.frontLegLeft.xRot = Mth.cos((float)(limbSwing * 2.0f)) * 4.0f * limbSwingAmount;
        this.frontLegRight.xRot = Mth.cos((float)(limbSwing * 2.0f + (float)Math.PI)) * 4.0f * limbSwingAmount;
        this.backLegLeft.xRot = Mth.cos((float)(limbSwing * 2.0f + (float)Math.PI)) * 4.0f * limbSwingAmount;
        this.backLegRight.xRot = Mth.cos((float)(limbSwing * 2.0f)) * 4.0f * limbSwingAmount;
    }
}

