/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.Gloomper;

public class GloomperModel<T extends Gloomper>
extends AgeableListModel<T> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart arms;
    private final ModelPart feet;
    private float jumpRotation;

    public GloomperModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.jaw = this.head.getChild("jaw");
        this.arms = root.getChild("arms");
        this.feet = root.getChild("feet");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -5.0f, -8.0f, 16.0f, 13.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)3.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 31).addBox(-5.0f, -4.5f, -2.0f, 10.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.5f, (float)-5.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(0, 43).addBox(-5.0f, -4.0f, -1.0f, 10.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.5f, (float)-2.0f));
        PartDefinition arms = partdefinition.addOrReplaceChild("arms", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)19.5f, (float)-3.5f));
        PartDefinition left = arms.addOrReplaceChild("left", CubeListBuilder.create().texOffs(22, 43).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.0f, (float)-0.5f, (float)-1.0f, (float)-0.5672f, (float)-0.4363f, (float)0.0f));
        PartDefinition right = arms.addOrReplaceChild("right", CubeListBuilder.create().texOffs(22, 43).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-7.0f, (float)-0.5f, (float)-1.0f, (float)-0.5672f, (float)0.4363f, (float)0.0f));
        PartDefinition feet = partdefinition.addOrReplaceChild("feet", CubeListBuilder.create().texOffs(28, 32).mirror().addBox(7.0f, 5.0f, -7.0f, 4.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(28, 32).addBox(-11.0f, 5.0f, -7.0f, 4.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 56).addBox(-11.0f, 0.0f, -3.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 56).mirror().addBox(7.0f, 0.0f, -3.0f, 4.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)17.0f, (float)8.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float age = ageInTicks - (float)((Gloomper)((Object)entity)).tickCount;
        this.jumpRotation = Mth.sin((float)(((Gloomper)((Object)entity)).getJumpCompletion(age) * (float)Math.PI));
        this.arms.xRot = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.feet.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        this.jumpRotation = Mth.sin((float)(((Gloomper)((Object)entity)).getJumpCompletion(partialTicks) * (float)Math.PI));
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableSet.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableSet.of((Object)this.body, (Object)this.head, (Object)this.arms, (Object)this.feet);
    }
}

