/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.block.InfuserBlock;
import quek.undergarden.block.InfuserState;
import quek.undergarden.component.RogdoriumInfusion;
import quek.undergarden.inventory.InfuserMenu;
import quek.undergarden.recipe.InfusingRecipe;
import quek.undergarden.registry.UGBlockEntities;
import quek.undergarden.registry.UGDataComponents;
import quek.undergarden.registry.UGRecipeTypes;
import quek.undergarden.registry.UGTags;

public class InfuserBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{3};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1, 2};
    private NonNullList<ItemStack> items = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    int infusingProgress;
    int infusingTotalTime;
    private final ContainerData containerData = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> InfuserBlockEntity.this.infusingProgress;
                case 1 -> InfuserBlockEntity.this.infusingTotalTime;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    InfuserBlockEntity.this.infusingProgress = value;
                    break;
                }
                case 1: {
                    InfuserBlockEntity.this.infusingTotalTime = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();

    public InfuserBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)UGBlockEntities.INFUSER.get(), pos, blockState);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.undergarden.infuser");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    public void setItem(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack);
        this.items.set(index, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        if (index == 0 && !flag) {
            this.infusingTotalTime = InfuserBlockEntity.getTotalInfusingTime(this.level, this);
            this.infusingProgress = 0;
            this.setChanged();
        }
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new InfuserMenu(containerId, inventory, (Container)this, this.containerData);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return side == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        return switch (index) {
            case 0 -> true;
            case 1 -> {
                if (((ItemStack)this.items.get(2)).isEmpty() && itemStack.is(UGTags.Items.INFUSER_UTHERIUM_FUELS)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (((ItemStack)this.items.get(1)).isEmpty() && itemStack.is(UGTags.Items.INFUSER_ROGDORIUM_FUELS)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return direction == Direction.DOWN && index == 3;
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.id();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void fillStackedContents(StackedContents contents) {
        for (ItemStack stack : this.items) {
            contents.accountStack(stack);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.infusingProgress = tag.getInt("InfusingTime");
        this.infusingTotalTime = tag.getInt("InfusingTimeTotal");
        CompoundTag compoundtag = tag.getCompound("RecipesUsed");
        for (String s : compoundtag.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)s), compoundtag.getInt(s));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("InfusingTime", this.infusingProgress);
        tag.putInt("InfusingTimeTotal", this.infusingTotalTime);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((p_187449_, p_187450_) -> compoundtag.putInt(p_187449_.toString(), p_187450_.intValue()));
        tag.put("RecipesUsed", (Tag)compoundtag);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, InfuserBlockEntity blockEntity) {
        boolean changed = false;
        boolean recipeFound = false;
        boolean isInfusing = blockEntity.infusingProgress > 0;
        ItemStack input = (ItemStack)blockEntity.items.getFirst();
        if (!input.isEmpty()) {
            List recipes = level.getRecipeManager().getRecipesFor((RecipeType)UGRecipeTypes.INFUSING.get(), (RecipeInput)new SingleRecipeInput(input), level);
            int i = blockEntity.getMaxStackSize();
            for (RecipeHolder recipe : recipes) {
                if (!blockEntity.canInfuse(level.registryAccess(), (RecipeHolder<InfusingRecipe>)recipe, blockEntity.items, i)) continue;
                recipeFound = true;
                ++blockEntity.infusingProgress;
                if (blockEntity.infusingProgress != blockEntity.infusingTotalTime) break;
                blockEntity.infusingProgress = 0;
                blockEntity.infusingTotalTime = InfuserBlockEntity.getTotalInfusingTime(level, blockEntity);
                if (blockEntity.infuse(level.registryAccess(), (RecipeHolder<InfusingRecipe>)recipe, blockEntity.items, i)) {
                    blockEntity.setRecipeUsed(recipe);
                }
                changed = true;
                break;
            }
            if (isInfusing != blockEntity.infusingProgress > 0) {
                changed = true;
            }
            if (!recipeFound) {
                blockEntity.infusingProgress = 0;
                changed = true;
            }
        }
        if (changed) {
            InfuserBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void setChanged() {
        if (this.level != null) {
            BlockState state = (BlockState)this.getBlockState().setValue(InfuserBlock.STATE, (Comparable)((Object)this.calculateState()));
            this.level.setBlock(this.getBlockPos(), state, 3);
        }
        super.setChanged();
    }

    private InfuserState calculateState() {
        boolean rogdorium;
        boolean utherium = !this.getItem(1).isEmpty();
        boolean bl = rogdorium = !this.getItem(2).isEmpty();
        return !utherium && !rogdorium ? InfuserState.INACTIVE : (utherium ? InfuserState.INFUSING_UTHERIUM : InfuserState.INFUSING_ROGDORIUM);
    }

    private boolean canInfuse(RegistryAccess registryAccess, @Nullable RecipeHolder<InfusingRecipe> recipe, NonNullList<ItemStack> inventory, int maxStackSize) {
        if (!((ItemStack)inventory.get(0)).isEmpty() && recipe != null) {
            ItemStack result = ((InfusingRecipe)recipe.value()).assemble((RecipeInput)new SingleRecipeInput((ItemStack)inventory.get(0)), (HolderLookup.Provider)registryAccess);
            RogdoriumInfusion component = (RogdoriumInfusion)result.getOrDefault(UGDataComponents.ROGDORIUM_INFUSION, (Object)RogdoriumInfusion.DEFAULT);
            int infusionAmount = component.infusionAmount();
            int infusionMax = component.infusionMax();
            if (infusionMax <= infusionAmount) {
                return false;
            }
            if (((ItemStack)inventory.get(((InfusingRecipe)recipe.value()).getRecipeSlotType().getSlotIndex())).isEmpty()) {
                return false;
            }
            if (result.isEmpty()) {
                return false;
            }
            ItemStack resultSlot = (ItemStack)inventory.get(3);
            if (resultSlot.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)resultSlot, (ItemStack)result)) {
                return false;
            }
            return resultSlot.getCount() + result.getCount() <= maxStackSize && resultSlot.getCount() + result.getCount() <= resultSlot.getMaxStackSize() || resultSlot.getCount() + result.getCount() <= result.getMaxStackSize();
        }
        return false;
    }

    private boolean infuse(RegistryAccess registryAccess, @Nullable RecipeHolder<InfusingRecipe> recipe, NonNullList<ItemStack> inventory, int maxStackSize) {
        if (recipe != null && this.canInfuse(registryAccess, recipe, inventory, maxStackSize)) {
            ItemStack input = (ItemStack)inventory.get(0);
            ItemStack result = ((InfusingRecipe)recipe.value()).assemble((RecipeInput)new SingleRecipeInput(input), (HolderLookup.Provider)registryAccess);
            ItemStack output = (ItemStack)inventory.get(3);
            ItemStack fuel = (ItemStack)inventory.get(2);
            if (ItemStack.isSameItem((ItemStack)input, (ItemStack)result)) {
                RogdoriumInfusion component = (RogdoriumInfusion)result.getOrDefault(UGDataComponents.ROGDORIUM_INFUSION, (Object)RogdoriumInfusion.DEFAULT);
                int infusionAmount = component.infusionAmount();
                int infusionMax = component.infusionMax();
                int fuelAmount = fuel.getCount();
                if (infusionMax <= infusionAmount) {
                    return false;
                }
                result.set(UGDataComponents.ROGDORIUM_INFUSION, (Object)RogdoriumInfusion.setInfusionAmount(Mth.clamp((int)(fuelAmount * 600 + infusionAmount), (int)0, (int)infusionMax)));
                fuel.shrink(Mth.clamp((int)fuelAmount, (int)1, (int)(infusionMax / 600)));
            } else {
                ((ItemStack)inventory.get(((InfusingRecipe)recipe.value()).getRecipeSlotType().getSlotIndex())).shrink(1);
            }
            if (output.isEmpty()) {
                inventory.set(3, (Object)result.copy());
            } else if (output.is(result.getItem())) {
                output.grow(result.getCount());
            }
            input.shrink(1);
            return true;
        }
        return false;
    }

    private static int getTotalInfusingTime(Level level, InfuserBlockEntity blockEntity) {
        SingleRecipeInput recipeInput = new SingleRecipeInput(blockEntity.getItem(0));
        return level.getRecipeManager().getRecipeFor((RecipeType)UGRecipeTypes.INFUSING.get(), (RecipeInput)recipeInput, level).map(infusingRecipe -> ((InfusingRecipe)infusingRecipe.value()).infusingTime()).orElse(200);
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(player.serverLevel(), player.position());
        player.awardRecipes(list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            player.triggerRecipeCrafted(recipeholder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 popVec) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(recipeHolder -> {
                if (recipeHolder.value() == UGRecipeTypes.INFUSING) {
                    list.add(recipeHolder);
                    InfuserBlockEntity.createExperience(level, popVec, entry.getIntValue(), ((InfusingRecipe)recipeHolder.value()).experience());
                }
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel level, Vec3 popVec, int recipeIndex, float experience) {
        int i = Mth.floor((float)((float)recipeIndex * experience));
        float f = Mth.frac((float)((float)recipeIndex * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)popVec, (int)i);
    }
}

