/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingGrongleLeavesBlock
extends DoublePlantBlock {
    private static final VoxelShape LOWER_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape UPPER_SHAPE = Block.box((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public HangingGrongleLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(level, pos);
        return state.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? LOWER_SHAPE.move(offset.x, offset.y, offset.z) : UPPER_SHAPE.move(offset.x, offset.y, offset.z);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(BlockTags.LEAVES);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)HALF);
        if (facing.getAxis() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (facing == Direction.DOWN) || facingState.is((Block)this) && facingState.getValue((Property)HALF) != half) {
            return half == DoubleBlockHalf.LOWER && facing == Direction.UP && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : (!state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : state);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        return level.getBlockState(pos.below()).canBeReplaced(context) ? this.defaultBlockState() : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack pStack) {
        BlockPos downPos = pos.below();
        level.setBlock(downPos, HangingGrongleLeavesBlock.copyWaterloggedFrom((LevelReader)level, (BlockPos)downPos, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER))), 3);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos upPos = pos.above();
        BlockState upState = level.getBlockState(upPos);
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            return this.mayPlaceOn(level.getBlockState(upPos), (BlockGetter)level, pos);
        }
        return upState.is((Block)this) && upState.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }
}

