/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import quek.undergarden.registry.UGItems;

public class DitchbulbBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<DitchbulbBlock> CODEC = DitchbulbBlock.simpleCodec(DitchbulbBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_1;
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public DitchbulbBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)UGItems.DITCHBULB.get());
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) != 1;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        int age = (Integer)state.getValue((Property)AGE);
        if (random.nextInt(10) == 0 && age != 1 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        int age = (Integer)state.getValue((Property)AGE);
        boolean maxAge = age == 1;
        return !maxAge && stack.is(Items.BONE_MEAL) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        boolean maxAge;
        int age = (Integer)state.getValue((Property)AGE);
        boolean bl = maxAge = age == 1;
        if (maxAge) {
            DitchbulbBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)UGItems.DITCHBULB.get()));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.getRandom().nextFloat() * 0.4f);
            BlockState newState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0));
            level.setBlock(pos, newState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, result);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return DitchbulbBlock.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !this.canSurvive(state, (LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Vec3 offset = state.getOffset((BlockGetter)level, pos);
        double x = (double)pos.getX() + 0.5 + offset.x();
        double y = (double)pos.getY() + 0.8 + offset.y();
        double z = (double)pos.getZ() + 0.5 + offset.z();
        if ((Integer)state.getValue((Property)AGE) == 1) {
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(level, pos);
        return SHAPE.move(offset.x(), offset.y(), offset.z());
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 1;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
    }
}

