/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import quek.undergarden.block.CarvedGloomgourdBlock;
import quek.undergarden.block.ShardTorchBlock;
import quek.undergarden.registry.UGDamageSources;
import quek.undergarden.registry.UGTags;

public class CarvedGloomgourdShardBlock
extends CarvedGloomgourdBlock {
    public CarvedGloomgourdShardBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, 20);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(4.0), entity -> entity.getType().is(UGTags.Entities.ROTSPAWN)).forEach(entity -> {
            if (entity.hurt(UGDamageSources.getShardTorchDamage((Level)level, pos.getCenter()), 4.0f)) {
                ShardTorchBlock.drawParticlesTo(level, pos.getCenter(), (Entity)entity);
            }
        });
        level.scheduleTick(pos, (Block)this, 20);
    }
}

